#
# Patch given file with DATA hunks and print to STDOUT.
#
#
# This patches uuid_compare() to myuuid_compare().
# For some reason, on FreeBSD, uuid_compare is linking
# to something else, possibly the system libuuid,
# even though we dont explicitly link it.
#
use strict;
use warnings;
use Text::Patch 'patch';

my $in = $ARGV[0];

my ($txt, $patch);
{
    local $/;
    open my $fh, '<', $in or die "open: $in: $!";
    $txt   = <$fh>;
    $patch = <DATA>;
}

#print $txt;
#print $patch;
#exit;

my $out = patch( $txt, $patch, STYLE => 'Unified' );

print $out;
exit 0;

__END__
--- usrc/uuid/compare.c	2023-11-29 23:03:41.791859643 -0500
+++ usrcP/uuid/compare.c	2023-12-04 03:18:57.852413604 -0500
@@ -40,7 +40,7 @@
 
 #define UUCMP(u1,u2) if (u1 != u2) return((u1 < u2) ? -1 : 1);
 
-int uuid_compare(const uuid_t uu1, const uuid_t uu2)
+int myuuid_compare(const uuid_t uu1, const uuid_t uu2)
 {
 	struct uuid	uuid1, uuid2;
 
