# automatically generated file, don't edit



# Copyright 2023 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::DE;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20230614174403;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            3[02]|
            40|
            [68]9
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,13})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            2(?:
              0[1-389]|
              12[0-8]
            )|
            3(?:
              [35-9][15]|
              4[015]
            )|
            906|
            2(?:
              [13][14]|
              2[18]
            )|
            (?:
              2[4-9]|
              4[2-9]|
              [579][1-9]|
              [68][1-8]
            )1
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            [24-6]|
            3(?:
              3(?:
                0[1-467]|
                2[127-9]|
                3[124578]|
                7[1257-9]|
                8[1256]|
                9[145]
              )|
              4(?:
                2[135]|
                4[13578]|
                9[1346]
              )|
              5(?:
                0[14]|
                2[1-3589]|
                6[1-4]|
                7[13468]|
                8[13568]
              )|
              6(?:
                2[1-489]|
                3[124-6]|
                6[13]|
                7[12579]|
                8[1-356]|
                9[135]
              )|
              7(?:
                2[1-7]|
                4[145]|
                6[1-5]|
                7[1-4]
              )|
              8(?:
                21|
                3[1468]|
                6|
                7[1467]|
                8[136]
              )|
              9(?:
                0[12479]|
                2[1358]|
                4[134679]|
                6[1-9]|
                7[136]|
                8[147]|
                9[1468]
              )
            )|
            70[2-8]|
            8(?:
              0[2-9]|
              [1-8]
            )|
            90[7-9]|
            [79][1-9]|
            3[68]4[1347]|
            3(?:
              47|
              60
            )[1356]|
            3(?:
              3[46]|
              46|
              5[49]
            )[1246]|
            3[4579]3[1357]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{2,11})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '138',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '3',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{2,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '181',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{5,11})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              3|
              80
            )|
            9
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d)(\\d{4,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '1[67]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{7,8})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '8',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{7,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18500',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '7',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18[68]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{7})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '15[0568]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '15[1279]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{7})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              6[023]|
              7
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{7,8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '15[279]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{7})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '15',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{8})'
                }
              ];

my $validators = {
                'fixed_line' => '
          32\\d{9,11}|
          49[1-6]\\d{10}|
          322\\d{6}|
          49[0-7]\\d{3,9}|
          (?:
            [34]0|
            [68]9
          )\\d{3,13}|
          (?:
            2(?:
              0[1-689]|
              [1-3569]\\d|
              4[0-8]|
              7[1-7]|
              8[0-7]
            )|
            3(?:
              [3569]\\d|
              4[0-79]|
              7[1-7]|
              8[1-8]
            )|
            4(?:
              1[02-9]|
              [2-48]\\d|
              5[0-6]|
              6[0-8]|
              7[0-79]
            )|
            5(?:
              0[2-8]|
              [124-6]\\d|
              [38][0-8]|
              [79][0-7]
            )|
            6(?:
              0[02-9]|
              [1-358]\\d|
              [47][0-8]|
              6[1-9]
            )|
            7(?:
              0[2-8]|
              1[1-9]|
              [27][0-7]|
              3\\d|
              [4-6][0-8]|
              8[0-5]|
              9[013-7]
            )|
            8(?:
              0[2-9]|
              1[0-79]|
              2\\d|
              3[0-46-9]|
              4[0-6]|
              5[013-9]|
              6[1-8]|
              7[0-8]|
              8[0-24-6]
            )|
            9(?:
              0[6-9]|
              [1-4]\\d|
              [589][0-7]|
              6[0-8]|
              7[0-467]
            )
          )\\d{3,12}
        ',
                'geographic' => '
          32\\d{9,11}|
          49[1-6]\\d{10}|
          322\\d{6}|
          49[0-7]\\d{3,9}|
          (?:
            [34]0|
            [68]9
          )\\d{3,13}|
          (?:
            2(?:
              0[1-689]|
              [1-3569]\\d|
              4[0-8]|
              7[1-7]|
              8[0-7]
            )|
            3(?:
              [3569]\\d|
              4[0-79]|
              7[1-7]|
              8[1-8]
            )|
            4(?:
              1[02-9]|
              [2-48]\\d|
              5[0-6]|
              6[0-8]|
              7[0-79]
            )|
            5(?:
              0[2-8]|
              [124-6]\\d|
              [38][0-8]|
              [79][0-7]
            )|
            6(?:
              0[02-9]|
              [1-358]\\d|
              [47][0-8]|
              6[1-9]
            )|
            7(?:
              0[2-8]|
              1[1-9]|
              [27][0-7]|
              3\\d|
              [4-6][0-8]|
              8[0-5]|
              9[013-7]
            )|
            8(?:
              0[2-9]|
              1[0-79]|
              2\\d|
              3[0-46-9]|
              4[0-6]|
              5[013-9]|
              6[1-8]|
              7[0-8]|
              8[0-24-6]
            )|
            9(?:
              0[6-9]|
              [1-4]\\d|
              [589][0-7]|
              6[0-8]|
              7[0-467]
            )
          )\\d{3,12}
        ',
                'mobile' => '
          15[0-25-9]\\d{8}|
          1(?:
            6[023]|
            7\\d
          )\\d{7,8}
        ',
                'pager' => '
          16(?:
            4\\d{1,10}|
            [89]\\d{1,11}
          )
        ',
                'personal_number' => '700\\d{8}',
                'specialrate' => '(
          180\\d{5,11}|
          13(?:
            7[1-6]\\d\\d|
            8
          )\\d{4}
        )|(
          (?:
            137[7-9]|
            900(?:
              [135]|
              9\\d
            )
          )\\d{6}
        )|(
          18(?:
            1\\d{5,11}|
            [2-9]\\d{8}
          )
        )',
                'toll_free' => '800\\d{7,12}',
                'voip' => ''
              };
my %areanames = ();
$areanames{en} = {"496243", "Monsheim",
"4936333", "Heringen\ Helme",
"499555", "Schlüsselfeld\-Aschbach",
"494432", "Dötlingen\-Brettorf",
"494724", "Cuxhaven\-Lüdingworth",
"495421", "Dissen\ am\ Teutoburger\ Wald",
"492637", "Weissenthurm",
"496755", "Odernheim\ am\ Glan",
"494706", "Schiffdorf",
"497578", "Wald\ Hohenz",
"498082", "Schwindegg",
"4939423", "Wegeleben",
"4938721", "Ziegendorf",
"4935775", "Pechern",
"492871", "Bocholt",
"494281", "Zeven",
"492445", "Schleiden\ Eifel",
"4936923", "Treffurt",
"4938735", "Plau\ am\ See",
"494493", "Friesoythe\-Gehlenberg",
"497825", "Kippenheim",
"499947", "Neukirchen\ bei\ Hl\ Blut",
"495372", "Meinersen",
"4935024", "Stadt\ Wehlen",
"499857", "Schopfloch\ Mittelfranken",
"495304", "Meine",
"496753", "Meisenheim",
"492552", "Steinfurt\-Borghorst",
"4934298", "Taucha\ bei\ Leipzig",
"495326", "Langelsheim",
"499553", "Ebrach\ Oberfranken",
"4933834", "Pritzerbe",
"496245", "Biblis",
"497364", "Oberkochen",
"497823", "Seelbach\ Schutter",
"494495", "Friesoythe\-Thüle",
"499442", "Riedenburg",
"4933966", "Dranse",
"4938755", "Eldena",
"499464", "Walderbach",
"4935694", "Gosda\ bei\ Klinge",
"4939601", "Friedland",
"492443", "Mechernich",
"4939488", "Güntersberge",
"497527", "Wolfegg",
"496425", "Rauschenberg\ Hessen",
"495074", "Rodewald",
"4938301", "Putbus",
"495751", "Rinteln",
"494454", "Jade",
"49212", "Solingen",
"497062", "Beilstein\ Württemberg",
"4939746", "Krackow",
"495069", "Nordstemmen",
"499276", "Bischofsgrün",
"497044", "Mönsheim",
"494563", "Scharbeutz\-Haffkrug",
"497624", "Grenzach\-Wyhlen",
"492223", "Königswinter",
"495187", "Delligsen",
"499222", "Presseck",
"493631", "Nordhausen\ Thüringen",
"492534", "Münster\-Roxel",
"4936695", "Söllmnitz",
"498191", "Landsberg\ am\ Lech",
"495241", "Gütersloh",
"4937608", "Waldenburg\ Sachsen",
"498631", "Mühldorf\ am\ Inn",
"496423", "Wetter\ Hessen",
"498384", "Röthenbach\ Allgäu",
"498459", "Manching",
"493573", "Senftenberg",
"492225", "Meckenheim\ Rheinland",
"496357", "Standenbühl",
"498460", "Berching\-Holnstein",
"4936259", "Tabarz\ Thüringer\ Wald",
"493877", "Wittenberge",
"498573", "Ering",
"4936025", "Körner",
"497271", "Wörth\ am\ Rhein",
"4933601", "Podelzig",
"497942", "Neuenstein\ Württemberg",
"497571", "Sigmaringen",
"498273", "Nordendorf",
"499294", "Regnitzlosau",
"494288", "Horstedt\ Kreis\ Rotenburg",
"494265", "Fintel",
"497964", "Stödtlen",
"49211", "Düsseldorf",
"495139", "Burgwedel",
"4934772", "Helbra",
"492525", "Beckum\-Neubeckum",
"4938220", "Wustrow\ Ostseebad",
"497132", "Neckarsulm",
"496167", "Modautal",
"49961", "Weiden\ in\ der\ Oberpfalz",
"497633", "Staufen\ im\ Breisgau",
"497193", "Sulzbach\ an\ der\ Murr",
"495541", "Hann\.\ Münden",
"495904", "Lengerich\ Emsl",
"495428", "Melle\-Neuenkirchen",
"495926", "Engden",
"494337", "Jevenstedt",
"492234", "Frechen",
"4935268", "Stauchitz",
"499522", "Eltmann",
"4938233", "Prerow\ Ostseebad",
"496776", "Dachsenhausen",
"492523", "Wadersloh",
"4939722", "Sarnow\ bei\ Anklam",
"4939889", "Boitzenburg",
"4936965", "Stadtlengsfeld",
"499347", "Wittighausen",
"496722", "Rüdesheim\ am\ Rhein",
"496434", "Bad\ Camberg",
"494263", "Scheessel",
"492827", "Goch\-Hassum",
"499576", "Lichtenfels\-Isling",
"4935728", "Uhyst\ Spree",
"497447", "Baiersbronn\-Schwarzenberg",
"4939262", "Güsten\ Anh",
"494180", "Königsmoor",
"4939854", "Kleptow",
"4938327", "Elmenhorst\ Vorpom",
"4939295", "Zuchau",
"495859", "Thomasburg",
"497195", "Winnenden",
"497852", "Willstätt",
"497635", "Schliengen",
"493821", "Ribnitz\-Damgarten",
"499189", "Berg\ bei\ Neumarkt\ in\ der\ Oberpfalz",
"497227", "Lichtenau\ Baden",
"494733", "Butjadingen\-Burhave",
"497154", "Kornwestheim",
"493984", "Prenzlau",
"4936947", "Jüchsen",
"498821", "Garmisch\-Partenkirchen",
"499253", "Weissenstadt",
"496545", "Blankenrath",
"492252", "Zülpich",
"492689", "Dierdorf",
"494792", "Worpswede",
"499745", "Wildflecken",
"496452", "Battenberg\ Eder",
"492779", "Greifenstein\-Beilstein",
"499608", "Kohlberg\ Oberpfalz",
"4936201", "Walschleben",
"4933746", "Werbig\ bei\ Jüterbog",
"4938876", "Roggendorf",
"494735", "Butjadingen\-Stollhamm",
"492742", "Wissen",
"492764", "Welschen\ Ennest",
"497834", "Wolfach",
"498556", "Haidmühle",
"495248", "Langenberg\ Kreis\ Gütersloh",
"496543", "Büchenbeuren",
"498638", "Waldkraiburg",
"499255", "Marktleugast",
"496400", "Mücke",
"4938724", "Siggelkow",
"498782", "Pfeffenhausen",
"494609", "Eggebek",
"496392", "Hauenstein\ Pfalz",
"495883", "Lemgow",
"494163", "Horneburg\ Niederelbe",
"4938852", "Wittenburg",
"494662", "Leck",
"494644", "Karby",
"4935055", "Höckendorf\ bei\ Dippoldiswalde",
"4934633", "Braunsbedra",
"497386", "Hayingen",
"4933479", "Küstrin\-Kietz",
"499965", "Sankt\ Englmar",
"49641", "Giessen",
"496055", "Freigericht",
"4934906", "Raguhn",
"496333", "Waldfischbach\-Burgalben",
"494165", "Hollenstedt\ Nordheide",
"494188", "Welle\ Nordheide",
"499634", "Wiesau",
"4939604", "Wildberg\ bei\ Altentreptow",
"4935691", "Bärenklau\ NL",
"499194", "Ebermannstadt",
"498649", "Schleching",
"498029", "Kreuth\ bei\ Tegernsee",
"497232", "Königsbach\-Stein",
"496267", "Fahrenbach\ Baden",
"49221", "Cologne",
"498591", "Obernzell",
"496335", "Trulben",
"497808", "Hohberg\ bei\ Offenburg",
"4935872", "Neusalza\-Spremberg",
"492962", "Olsberg",
"498046", "Bad\ Heilbrunn",
"4939863", "Seehausen\ bei\ Prenzlau",
"4935021", "Königstein\ Sächsische\ Schweiz",
"496053", "Wächtersbach",
"499963", "Konzell",
"4934202", "Delitzsch",
"493672", "Rudolstadt",
"492501", "Münster\-Hiltrup",
"492944", "Rietberg\-Mastholte",
"4934653", "Rottleberode",
"493591", "Bautzen",
"4933831", "Weseram",
"499381", "Volkach",
"492694", "Wershofen",
"497762", "Wehr\ Baden",
"492832", "Kevelaer",
"492655", "Weibern",
"496737", "Köngernheim",
"4935323", "Sonnewalde",
"49781", "Offenburg",
"495769", "Steyerberg\-Voigtei",
"499833", "Heidenheim\ Mittelfranken",
"497744", "Stühlingen",
"4937439", "Jocketa",
"494953", "Bunde",
"495774", "Wagenfeld\-Ströhen",
"498507", "Neuburg\ am\ Inn",
"495702", "Petershagen\-Lahde",
"494471", "Cloppenburg",
"4938304", "Garz\ Rügen",
"4935606", "Briesen\ bei\ Cottbus",
"498366", "Oy\-Mittelberg",
"492597", "Senden\ Westfalen",
"497709", "Wutach",
"4936842", "Oberhof\ Thüringen",
"492208", "Niederkassel",
"493366", "Beeskow",
"4933398", "Werneuchen",
"495436", "Nortrup",
"499155", "Simmelsdorf",
"495051", "Bergen\ Kreis\ Celle",
"4935933", "Neschwitz",
"494845", "Ostenfeld\ Husum",
"495148", "Steinhorst\ Niedersachsen",
"498803", "Peissenberg",
"4938370", "Kröslin",
"4939382", "Kamern",
"494955", "Westoverledingen",
"497254", "Waghäusel",
"499289", "Schwarzenbach\ am\ Wald",
"496881", "Lebach",
"497127", "Neckartenzlingen",
"496094", "Weibersbrunn",
"4934362", "Mügeln\ bei\ Oschatz",
"499652", "Waidhaus",
"495684", "Frielendorf",
"499835", "Ehingen\ Mittelfranken",
"492653", "Kaisersesch",
"4935388", "Klöden",
"496408", "Buseck",
"498630", "Oberneukirchen",
"4938787", "Glöwen",
"498805", "Hohenpeissenberg",
"492152", "Kempen",
"494843", "Viöl",
"4935953", "Burkau",
"499153", "Schnaittach",
"494322", "Bordesholm",
"495331", "Wolfenbüttel",
"493461", "Merseburg\ Saale",
"498461", "Beilngries",
"494547", "Gudow\ Lauenburg",
"497570", "Sigmaringen\-Gutenstein",
"4939825", "Wokuhl",
"494247", "Affinghausen",
"499363", "Arnstein\ Unterfranken",
"499824", "Dietenhofen",
"492362", "Dorsten",
"497463", "Mühlheim\ an\ der\ Donau",
"4933878", "Nennhausen",
"4939831", "Feldberg",
"496145", "Flörsheim\ am\ Main",
"492309", "Waltrop",
"496789", "Heimbach\ Nahe",
"4933604", "Lebus",
"495403", "Bad\ Iburg",
"493836", "Wolgast",
"497554", "Heiligenberg\ Baden",
"494757", "Wanna",
"492508", "Drensteinfurt",
"4939851", "Göritz\ bei\ Prenzlau",
"4935240", "Tauscha\ bei\ Grossenhain",
"497465", "Emmingen\-Liptingen",
"4939408", "Hadmersleben",
"492297", "Wildbergerhütte",
"4935205", "Ottendorf\-Okrilla",
"494394", "Bokhorst",
"498207", "Affing",
"499365", "Rimpar",
"495861", "Dannenberg\ Elbe",
"494181", "Buchholz\ in\ der\ Nordheide",
"496642", "Schlitz",
"496022", "Obernburg\ am\ Main",
"495405", "Hasbergen\ Kreis\ Osnabrück",
"496664", "Sinntal\-Sterbfritz",
"494478", "Cappeln\ Oldenburg",
"495931", "Meppen",
"494922", "Borkum",
"494976", "Spiekeroog",
"499625", "Kastl\ bei\ Amberg",
"495141", "Celle",
"498291", "Zusmarshausen",
"496306", "Trippstadt",
"49251", "Münster",
"497532", "Meersburg",
"496567", "Oberkail",
"494355", "Rieseby",
"496324", "Hassloch",
"497171", "Schwäbisch\ Gmünd",
"492622", "Bendorf\ am\ Rhein",
"4938486", "Gustävel",
"492064", "Dinslaken",
"498468", "Altmannstein\-Pondorf",
"492676", "Ulmen",
"4939398", "Gross\ Garz",
"493966", "Cölpin",
"4936738", "Königsee",
"499176", "Allersberg",
"4936204", "Stotternheim",
"4935365", "Falkenberg\ Elster",
"497657", "Eisenbach\ Hochschwarzwald",
"496888", "Lebach\-Steinbach",
"496865", "Mettlach\-Orscholz",
"499122", "Schwabach",
"494353", "Ascheffel",
"496401", "Grünberg\ Hessen",
"4936377", "Rastenberg",
"49631", "Kaiserslautern",
"499295", "Töpen",
"494242", "Syke",
"492506", "Münster\-Wolbeck",
"498041", "Bad\ Tölz",
"494264", "Sottrum\ Kreis\ Rotenburg",
"492367", "Henrichenburg",
"498621", "Trostberg",
"497965", "Ellwangen\-Röhlingen",
"498158", "Tutzing",
"496433", "Hadamar",
"493596", "Neustadt\ in\ Sachsen",
"493621", "Gotha\ Thüringen",
"4939032", "Mahlsdorf\ bei\ Salzwedel",
"499386", "Prosselsheim",
"492524", "Ennigerloh",
"497486", "Horb\-Altheim",
"4933633", "Spreenhagen",
"496078", "Gross\-Umstadt",
"495905", "Beesten",
"4935893", "Mücka",
"495320", "Torfhaus",
"492235", "Erftstadt",
"4933653", "Ziltendorf",
"497381", "Münsingen",
"4939052", "Erxleben\ bei\ Haldensleben",
"4936929", "Ruhla",
"499481", "Pfatter",
"494752", "Neuhaus\ Oste",
"4935058", "Pretzschendorf",
"496435", "Wallmerod",
"492292", "Windeck\ Sieg",
"497963", "Adelmannsfelden",
"499293", "Berg\ Oberfranken",
"498274", "Buttenwiesen",
"4933202", "Töplitz",
"4938201", "Gelbensande",
"498202", "Althegnenberg",
"492233", "Hürth\ Rheinland",
"498250", "Hilgertshausen\-Tandern",
"499232", "Wunsiedel",
"498269", "Unteregg\ bei\ Mindelheim",
"497194", "Spiegelberg",
"496027", "Stockstadt\ am\ Main",
"495903", "Emsbüren",
"496647", "Herbstein\-Stockhausen",
"493838", "Bergen\ auf\ Rügen",
"497634", "Sulzburg",
"494927", "Krummhörn\-Loquard",
"493466", "Artern\ Unstrut",
"496509", "Büdlich",
"4939457", "Benneckenstein\ Harz",
"495336", "Semmenstedt",
"4938466", "Jürgenshagen",
"4936253", "Georgenthal\ Thüringer\ Wald",
"4936602", "Ronneburg\ Thüringen",
"494371", "Burg\ auf\ Fehmarn",
"493968", "Schönbeck",
"492678", "Büchel\ bei\ Cochem",
"498466", "Denkendorf\ Oberbayern",
"4935385", "Annaburg",
"496544", "Rhaunen",
"496562", "Speicher",
"499178", "Abenberg\ Mittelfranken",
"49981", "Ansbach",
"492763", "Drolshagen\-Bleche",
"497833", "Hornberg\ Schwarzwaldbahn",
"499744", "Zeitlofs\-Detter",
"4938296", "Rerik\ Ostseebad",
"499762", "Saal\ an\ der\ Saale",
"499270", "Creussen",
"492627", "Braubach",
"498361", "Nesselwang",
"4933395", "Zerpenschleuse",
"497153", "Plochingen",
"495056", "Winsen\-Meissendorf",
"494734", "Stadland\-Seefeld",
"494422", "Sande\ Kreis\ Friesl",
"495431", "Quakenbrück",
"493361", "Fürstenwalde\ Spree",
"495659", "Ringgau",
"4933362", "Liepe\ Kreis\ Barnim",
"497652", "Hinterzarten",
"497835", "Zell\ am\ Harmersbach",
"496308", "Olsbrücken",
"499127", "Rosstal\ Mittelfranken",
"495282", "Schieder\-Schwalenberg",
"499254", "Gefrees",
"495582", "Sankt\ Andreasberg",
"4933844", "Brück\ Brandenburg",
"499554", "Untersteinbach\ Unterfranken",
"496397", "Leimen\ Pfalz",
"494725", "Helgoland",
"494186", "Buchholz\-Trelde",
"496071", "Dieburg",
"492409", "Stolberg\-Gressenich",
"496754", "Martinstein",
"4934604", "Niemberg",
"495303", "Wendeburg",
"4933052", "Leegebruch",
"494667", "Dagebüll",
"498151", "Starnberg",
"498628", "Kienberg\ Oberbayern",
"497806", "Bad\ Peterstal\-Griesbach",
"4939883", "Gross\ Dölln",
"4935208", "Radeburg",
"4939405", "Hötensleben",
"492444", "Schleiden\-Gemünd",
"4939202", "Gross\ Ammensleben",
"499463", "Wald\ Oberpfalz",
"493628", "Arnstadt",
"49234", "Bochum",
"4936940", "Oepfershausen",
"492462", "Linnich",
"497363", "Lauchheim",
"497824", "Schwanau",
"4935754", "Klettwitz",
"495305", "Sickte",
"493831", "Stralsund",
"496262", "Aglasterhausen",
"497237", "Neulingen\ Enzkreis",
"494723", "Cuxhaven\-Altenwalde",
"496244", "Westhofen\ Rheinhessenen",
"497388", "Pfronstetten",
"497365", "Essingen\ Württemberg",
"4935822", "Hagenwerder",
"494494", "Bösel\ Oldenburg",
"4933875", "Rhinow",
"499465", "Neukirchen\-Balbini",
"493677", "Ilmenau\ Thüringen",
"498677", "Burghausen\ Salzach",
"4939828", "Wustrow\ Kreis\ Mecklenburg\-Strelitz",
"496209", "Mörlenbach",
"496732", "Wörrstadt",
"496424", "Ebsdorfergrund",
"4939991", "Daberkow",
"492837", "Weeze",
"4939362", "Grieben\ bei\ Tangerhütte",
"499171", "Roth\ Mittelfranken",
"499532", "Maroldsweisach",
"496406", "Lollar",
"4938333", "Horst\ bei\ Grimmen",
"4937294", "Grünhainichen",
"492533", "Münster\-Nienberge",
"498550", "Philippsreut",
"494455", "Jade\-Schweiburg",
"4934382", "Nerchau",
"4939395", "Wanzer",
"498574", "Wittibreut",
"495707", "Petershagen\ Weser",
"4937464", "Schöneck\ Vogtland",
"498502", "Fürstenzell",
"4936735", "Probstzella",
"492592", "Selm",
"497625", "Zell\ im\ Wiesental",
"497045", "Oberderdingen",
"4936041", "Bad\ Tennstedt",
"493961", "Altentreptow",
"4933437", "Reichenberg\ bei\ Strausberg",
"493574", "Lauchhammer",
"4938227", "Lüdershagen\ bei\ Barth",
"492671", "Cochem",
"498383", "Grünenbach\ Allgäu",
"495129", "Söhlde",
"494453", "Zetel",
"492535", "Sendenhorst\-Albersloh",
"4938320", "Tribsees",
"497122", "St\ Johann\ Württemberg",
"496301", "Otterbach\ Pfalz",
"4938353", "Gützkow\ bei\ Greifswald",
"499657", "Waldthurn",
"495073", "Neustadt\-Esperke",
"497176", "Spraitbach",
"498385", "Hergatz",
"498368", "Halblech",
"492157", "Nettetal\-Kaldenkirchen",
"495936", "Twist",
"4933457", "Altreetz",
"494327", "Grossenaspe",
"492224", "Bad\ Honnef",
"497043", "Maulbronn",
"498296", "Villenbach",
"495146", "Wietze",
"497623", "Rheinfelden\ Baden",
"494564", "Schashagen",
"494971", "Esens",
"493385", "Rathenow",
"495438", "Bakum\-Lüsche",
"492206", "Overath",
"494542", "Mölln\ Lauenburg",
"4934262", "Falkenhain\ bei\ Wurzen",
"499825", "Herrieden",
"497947", "Forchtenberg",
"494393", "Boostedt",
"4934659", "Blankenheim\ bei\ Sangerhausen",
"4939485", "Gernrode\ Harz",
"4938758", "Dömitz",
"4934722", "Preusslitz",
"496144", "Bischofsheim\ bei\ Rüsselsheim",
"496162", "Reinheim\ Odenwald",
"4934465", "Bad\ Bibra",
"496663", "Steinau\ an\ der\ Strasse",
"495977", "Spelle",
"498741", "Vilsbiburg",
"4934295", "Krensitz",
"493741", "Plauen",
"4934492", "Lucka",
"496109", "Frankfurt\-Bergen\-Enkheim",
"494332", "Hamdorf\ bei\ Rendsburg",
"495321", "Goslar",
"497555", "Deggenhausertal",
"494286", "Gyhum",
"499527", "Knetzgau",
"4933473", "Zechin",
"499480", "Sünching",
"4938738", "Karow\ bei\ Lübz",
"4939772", "Rothemühl",
"4938780", "Lanz\ Brandenburg",
"497464", "Talheim\ Kreis\ Tuttlingen",
"492822", "Emmerich",
"4934639", "Wallendorf\ Luppe",
"496727", "Gensingen",
"499342", "Wertheim",
"499364", "Zellingen",
"499823", "Leutershausen",
"497442", "Baiersbronn",
"497553", "Salem\ Baden",
"498251", "Aichach",
"495426", "Glandorf",
"4938377", "Zinnowitz",
"495472", "Bad\ Essen",
"495404", "Westerkappeln",
"4938204", "Broderstorf",
"496665", "Sinntal\-Altengronau",
"497222", "Rastatt",
"498039", "Rott\ am\ Inn",
"499606", "Pfreimd",
"4936028", "Kammerforst\ Thüringen",
"497276", "Herxheim\ bei\ Landau\ Pfalz",
"499624", "Ensdorf\ Oberpfalz",
"494489", "Apen",
"493636", "Greussen",
"4937605", "Hartenstein\ Sachsen",
"492257", "Reckerscheid",
"494354", "Fleckeby",
"496325", "Lambrecht\ Pfalz",
"498636", "Ampfing",
"495246", "Verl",
"498196", "Pürgen",
"498558", "Hohenau\ Niederbayern",
"496457", "Burgwald\ Eder",
"4935939", "Hochkirch",
"499271", "Thurnau\-Alladorf",
"4938826", "Dassow",
"492065", "Duisburg\-Rheinhausen",
"4936083", "Uder",
"496842", "Blieskastel",
"492747", "Molzhain",
"496864", "Mettlach",
"496323", "Edenkoben",
"4937433", "Gutenfürst",
"495661", "Melsungen",
"4935329", "Dollenchen",
"4939298", "Barby\ Elbe",
"499193", "Höchstadt\ an\ der\ Aisch",
"492632", "Andernach",
"498102", "Höhenkirchen\-Siegertsbrunn",
"492855", "Voerde\ Niederrhein",
"49761", "Freiburg\ im\ Breisgau",
"492192", "Hückeswagen",
"495328", "Altenau\ Harz",
"499633", "Mitterteich",
"499132", "Herzogenaurach",
"4938842", "Lüttenmark",
"4933841", "Belzig",
"492693", "Antweiler",
"492133", "Dormagen",
"4936968", "Rossdorf\ Rhön",
"4933986", "Falkenhagen\ Kreis\ Prignitz",
"4935725", "Wittichenau",
"496771", "St\ Goarshausen",
"4934601", "Teutschenthal",
"492943", "Erwitte",
"493603", "Bad\ Langensalza",
"499964", "Stallwang",
"496054", "Birstein",
"4935265", "Glaubitz",
"499942", "Viechtach",
"499571", "Lichtenfels\ Bayern",
"499852", "Feuchtwangen",
"495546", "Scheden",
"494164", "Harsefeld",
"499635", "Bärnau",
"498258", "Sielenbach",
"495377", "Ehra\-Lessien",
"492853", "Schermbeck",
"494142", "Steinkirchen\ Kreis\ Stade",
"499195", "Adelsdorf\ Mittelfranken",
"4936370", "Grossenehrich",
"495921", "Nordhorn",
"494708", "Ringstedt",
"4937206", "Frankenberg\ Sachsen",
"494932", "Norderney",
"492557", "Wettringen\ Kreis\ Steinfurt",
"496681", "Hilders",
"4935751", "Welzow",
"499447", "Essing",
"496334", "Thaleischweiler\-Fröschen",
"494179", "Winsen\-Tönnhausen",
"497347", "Dietenheim",
"493605", "Leinefelde",
"492945", "Lippstadt\-Benninghausen",
"497576", "Krauchenwies",
"495529", "Rhumspringe",
"494643", "Gelting\ Angeln",
"497522", "Wangen\ im\ Allgäu",
"4934423", "Heuckewalde",
"492695", "Insul",
"492654", "Polch",
"499170", "Schwanstetten",
"495683", "Wabern\ Hessen",
"497745", "Jestetten",
"496093", "Laufach",
"498551", "Freyung",
"497253", "Bad\ Schönborn",
"495775", "Diepenau",
"496032", "Bad\ Nauheim",
"4939994", "Metschow",
"4937291", "Augustusburg",
"495182", "Gronau\ Leine",
"494862", "Garding",
"499154", "Pommelsbrunn",
"494844", "Pellworm",
"499227", "Neuenmarkt",
"49471", "Bremerhaven",
"494954", "Moormerland",
"497255", "Graben\-Neudorf",
"4937752", "Eibenstock",
"496095", "Bessenbach",
"497743", "Ühlingen\-Birkendorf",
"495685", "Knüllwald",
"499834", "Theilenhofen",
"499278", "Weidenberg",
"4933677", "Glienicke\ bei\ Beeskow",
"4937366", "Rübenau",
"496352", "Kirchheimbolanden",
"4936075", "Dingelstädt\ Eichsfeld",
"495773", "Stemwede\-Wehdem",
"4934746", "Giersleben",
"4935247", "Zehren\ Sachsen",
"494120", "Ellerhoop",
"49841", "Ingolstadt\ Donau",
"498055", "Halfing",
"498333", "Babenhausen\ Schwaben",
"492369", "Dorsten\-Wulfen",
"49341", "Leipzig",
"496175", "Friedrichsdorf\ Taunus",
"495554", "Moringen",
"492583", "Sassenberg",
"4934907", "Jeber\-Bergfrieden",
"4934652", "Allstedt",
"497403", "Dunningen",
"492302", "Witten",
"496782", "Birkenfeld\ Nahe",
"4934203", "Zwenkau",
"494277", "Schwaförden",
"492374", "Iserlohn\-Letmathe",
"499303", "Eibelstadt",
"4939862", "Schmölln\ bei\ Prenzlau",
"498392", "Markt\ Rettenbach",
"4935873", "Herrnhut",
"496672", "Eiterfeld",
"495465", "Neuenkirchen\ bei\ Bramsche",
"493335", "Finowfurt",
"496626", "Wildeck\-Obersuhl",
"498335", "Fellheim",
"496591", "Gerolstein",
"496046", "Ortenberg\ Hessen",
"498053", "Bad\ Endorf",
"496029", "Mömbris",
"499305", "Estenfeld",
"498267", "Dirlewang",
"499090", "Rain\ Lech",
"4939779", "Eggesin",
"4939081", "Kakerbeck\ Sachsen\-Anhalt",
"4937321", "Frankenstein\ Sachsen",
"4934241", "Jesewitz",
"4934632", "Mücheln\ Geiseltal",
"499920", "Bischofsmais",
"492568", "Heek",
"492585", "Warendorf\-Hoetmar",
"4938853", "Drönnewitz\ bei\ Hagenow",
"496173", "Kronberg\ im\ Taunus",
"497141", "Ludwigsburg\ Württemberg",
"495593", "Bovenden\-Lenglern",
"496298", "Möckmühl",
"4934363", "Cavertitz",
"496803", "Mandelbachtal\-Ommersheim",
"496507", "Neumagen\-Dhron",
"494929", "Ihlow\ Kreis\ Aurich",
"497931", "Bad\ Mergentheim",
"4939383", "Sandau\ Elbe",
"499075", "Glött",
"494946", "Grossefehn\-Bagband",
"492261", "Gummersbach",
"493737", "Rochlitz",
"495171", "Peine",
"495532", "Stadtoldendorf",
"4936458", "Bad\ Berka",
"494521", "Eutin",
"4935952", "Grossröhrsdorf\ OL",
"4935607", "Jänschwalde",
"494136", "Scharnebeck",
"496461", "Biedenkopf",
"499936", "Wallerfing",
"4939328", "Rochau",
"499146", "Markt\ Berolzheim",
"496805", "Kleinblittersdorf",
"4935322", "Doberlug\-Kirchhain",
"499438", "Fensterbach",
"494856", "Kronprinzenkoog",
"499129", "Wendelstein",
"493881", "Grevesmühlen",
"492646", "Königsfeld\ Eifel",
"496190", "Hattersheim\ am\ Main",
"4935932", "Guttau",
"496630", "Schwalmtal\-Storndorf",
"4936843", "Benshausen",
"495657", "Meissner",
"4933971", "Kyritz\ Brandenburg",
"498094", "Steinhöring",
"499073", "Gundelfingen\ an\ der\ Donau",
"492407", "Herzogenrath\-Kohlscheid",
"49375", "Zwickau",
"499905", "Bernried\ Niederbayern",
"4933708", "Rangsdorf",
"4938794", "Cumlosen",
"496836", "Überherrn",
"497420", "Deisslingen",
"494602", "Freienwill",
"494674", "Ockholm",
"497587", "Hosskirch",
"494103", "Wedel",
"498145", "Mammendorf",
"493935", "Tangerhütte",
"495295", "Lichtenau\ Westfalen",
"4938424", "Bobitz",
"4933234", "Wustermark",
"498642", "Übersee",
"498022", "Tegernsee",
"495232", "Lage\ Lippe",
"498664", "Chieming",
"494221", "Delmenhorst",
"492561", "Ahaus",
"499903", "Schöllnach",
"4937360", "Olbernhau",
"498076", "Pfaffing",
"492974", "Schmallenberg\-Fredeburg",
"492902", "Warstein",
"492738", "Netphen",
"498679", "Burgkirchen\ an\ der\ Alz",
"496207", "Wald\-Michelbach",
"495481", "Lengerich\ Westfalen",
"4939004", "Köckte\ bei\ Gardelegen",
"495293", "Paderborn\-Dahl",
"493933", "Genthin",
"498143", "Inning\ am\ Ammersee",
"495808", "Gerdau",
"493679", "Neuhaus\ am\ Rennweg",
"494105", "Seevetal",
"4934955", "Gossa",
"498324", "Hindelang",
"493306", "Gransee",
"494875", "Stafstedt",
"492268", "Kürten",
"494441", "Vechta",
"498306", "Ronsberg",
"49581", "Uelzen",
"494528", "Schönwalde\ am\ Bungsberg",
"492839", "Straelen\-Herongen",
"4939971", "Gnoien",
"495744", "Hüllhorst",
"493863", "Crivitz",
"497051", "Calw",
"497148", "Grossbottwar",
"499336", "Bütthard",
"496291", "Adelsheim",
"497436", "Messstetten\-Oberdigisheim",
"497774", "Eigeltingen",
"497938", "Mulfingen\ Jagst",
"497702", "Blumberg\ Baden",
"496483", "Selters\ Taunus",
"499659", "Leuchtenberg",
"493865", "Holthusen",
"494346", "Gettorf",
"4934921", "Kemberg",
"497240", "Pfinztal",
"497684", "Glottertal",
"494873", "Aukrug",
"495127", "Harsum",
"499282", "Naila",
"4939344", "Güsen",
"495254", "Paderborn\-Schloss\ Neuhaus",
"496485", "Nentershausen\ Westerwald",
"496468", "Dautphetal\-Mornshausen",
"4937200", "Wittgensdorf\ bei\ Chemnitz",
"4934325", "Mochau\-Lüttewitz",
"4936376", "Straussfurt",
"492159", "Meerbusch\-Osterath",
"497331", "Geislingen\ an\ der\ Steige",
"494329", "Langwedel\ Holstein",
"499431", "Schwandorf",
"495132", "Lehrte",
"494121", "Elmshorn",
"497139", "Neuenstadt\ am\ Kocher",
"495692", "Wolfhagen",
"494536", "Steinhorst\ Lauenburg",
"492351", "Lüdenscheid",
"497949", "Pfedelbach\-Untersteinbach",
"496082", "Niederreifenberg",
"495964", "Lähden",
"495942", "Uelsen",
"495571", "Uslar",
"496107", "Kelsterbach",
"4936766", "Schalkau",
"497428", "Rosenfeld",
"498243", "Fuchstal",
"497904", "Ilshofen",
"495193", "Schneverdingen",
"497541", "Friedrichshafen",
"4939039", "Bonese",
"497972", "Gschwend\ bei\ Gaildorf",
"494205", "Ottersberg",
"495633", "Diemelsee",
"496256", "Lampertheim\-Hüttenfeld",
"495447", "Lembruch",
"492958", "Büren\-Harth",
"499529", "Oberaurach",
"492456", "Selfkant",
"4937324", "Reinsberg\ Sachsen",
"4934244", "Mockrehna",
"4939084", "Lindstedt",
"4936332", "Ellrich",
"4939225", "Altengrabow",
"499546", "Burgebrach",
"495852", "Bleckede",
"499091", "Monheim\ Schwaben",
"4934785", "Sandersleben",
"499377", "Freudenberg\-Boxtal",
"495635", "Vöhl",
"494203", "Weyhe\ bei\ Bremen",
"4936922", "Gerstungen",
"497477", "Jungingen\ bei\ Hechingen",
"495195", "Neuenkirchen\ bei\ Soltau",
"4939059", "Wegenstedt",
"498245", "Türkheim\ Wertach",
"499921", "Regen",
"496746", "Pfalzfeld",
"4933967", "Freyenstein",
"498753", "Elsendorf\ Niederbayern",
"4933209", "Caputh",
"4939422", "Badersleben",
"499775", "Schönau\ an\ der\ Brend",
"499182", "Velburg",
"496575", "Landscheid",
"495154", "Aerzen",
"492183", "Rommerskirchen",
"497930", "Boxberg\ Baden",
"492682", "Hamm\ Sieg",
"493425", "Wurzen",
"499683", "Friedenfels",
"4939747", "Züsedom",
"49228", "Bonn",
"494487", "Grossenkneten\-Huntlosen",
"495278", "Höxter\-Ovenhausen",
"4933369", "Oderberg",
"496573", "Gillenfeld",
"496384", "Konken",
"492772", "Herborn\ Hessen",
"4933974", "Dessow",
"499773", "Unsleben",
"4936870", "Masserberg",
"496631", "Alsfeld",
"497248", "Marxzell",
"498423", "Titting",
"493423", "Eilenburg",
"495834", "Wittingen\-Knesebeck",
"498686", "Petting",
"4939263", "Unseburg",
"499977", "Arnschwang",
"4939209", "Wanzleben",
"4939723", "Krien",
"4933765", "Märkisch\ Buchholz",
"492841", "Moers",
"493686", "Eisfeld",
"4935475", "Straupitz",
"4933231", "Pausin",
"4938232", "Zingst\ Ostseebad",
"499321", "Kitzingen",
"494128", "Kollmar",
"495825", "Wieren",
"494766", "Basdahl",
"492358", "Meinerzhagen\-Valbert",
"498167", "Zolling",
"4938791", "Bad\ Wilsnack",
"4933084", "Gutengermendorf",
"4937348", "Oberwiesenthal\ Kurort",
"499426", "Oberschneiding",
"4935829", "Gersdorf\ bei\ Görlitz",
"497326", "Neresheim",
"4934773", "Schwittersdorf",
"495379", "Sassenburg\-Grussendorf",
"4939001", "Apenburg",
"499472", "Hohenfels\ Oberpfalz",
"499928", "Kirchdorf\ im\ Wald",
"499404", "Nittendorf",
"492473", "Simmerath",
"4938455", "Plaaz",
"497304", "Blaustein\ Württemberg",
"492951", "Büren",
"498434", "Rennertshofen",
"498722", "Gangkofen",
"495527", "Duderstadt",
"496275", "Rothenberg\ Odenwald",
"4938326", "Grimmen",
"495823", "Bienenbüttel",
"493722", "Limbach\-Oberfrohna",
"495364", "Velpke",
"494177", "Drage\ Elbe",
"497751", "Waldshut",
"497666", "Denzlingen",
"4936946", "Erbenhausen\ Thüringen",
"494382", "Wangels",
"4936651", "Lobenstein",
"494503", "Timmendorfer\ Strand",
"498545", "Hofkirchen\ Bayern",
"499246", "Pegnitz\-Trockau",
"495606", "Zierenberg",
"496821", "Neunkirchen\ Saar",
"499229", "Mainleus",
"495624", "Bad\ Emstal",
"495044", "Springe\-Eldagsen",
"495062", "Holle\ bei\ Hildesheim",
"4936625", "Langenwetzendorf",
"496556", "Pronsfeld",
"496198", "Eppstein",
"498543", "Aidenbach",
"496638", "Schwalmtal\-Renzendorf",
"493847", "Sternberg",
"494505", "Stockelsdorf\-Curau",
"499661", "Sulzbach\-Rosenberg",
"498847", "Obersöchering",
"4933747", "Marzahna",
"492161", "Mönchengladbach",
"495271", "Höxter",
"4934924", "Zahna",
"494236", "Kirchlinteln",
"498452", "Geisenfeld",
"4939341", "Redekin",
"497328", "Königsbronn",
"49561", "Kassel",
"492639", "Anhausen\ Kreis\ Neuwied",
"4938859", "Alt\ Zachun",
"492973", "Eslohe\ Sauerland",
"499428", "Kirchroth",
"499904", "Lalling",
"493663", "Schleiz",
"499972", "Waldmünchen",
"498663", "Ruhpolding",
"4939773", "Altwarp",
"4935600", "Döbern\ NL",
"4933472", "Golzow\ bei\ Seelow",
"496741", "St\ Goar",
"499926", "Frauenau",
"495294", "Hövelhof\-Espeln",
"498144", "Grafrath",
"4935795", "Königsbrück",
"492451", "Geilenkirchen",
"496620", "Philippsthal\ Werra",
"494673", "Joldelund",
"494939", "Baltrum",
"498665", "Inzell",
"496251", "Bensheim",
"4935451", "Dahme\ Brandenburg",
"497546", "Oberteuringen",
"492975", "Schmallenberg\-Oberkirchen",
"4934263", "Hohburg",
"494149", "Fredenbeck",
"495522", "Osterode\ am\ Harz",
"494531", "Bad\ Oldesloe",
"498727", "Falkenberg\ Niederbayern",
"497529", "Waldburg\ Württemberg",
"494768", "Hipstedt",
"4934493", "Gössnitz\ Thüringen",
"494126", "Horst\ Holstein",
"495347", "Burgdorf\ bei\ Salzgitter",
"494172", "Salzhausen",
"494104", "Aumühle\ bei\ Hamburg",
"493727", "Mittweida",
"4938376", "Zirchow",
"495253", "Bad\ Driburg",
"498325", "Oberstaufen\-Thalkirchdorf",
"496636", "Romrod",
"494802", "Wrohm",
"496196", "Bad\ Soden\ am\ Taunus",
"494874", "Todenbüttel",
"496558", "Büdesheim\ Eifel",
"4936082", "Ershausen",
"4936849", "Kleinschmalkalden",
"497683", "Simonswald",
"495745", "Stemwede\-Levern",
"4934341", "Geithain",
"4936424", "Kahla\ Thüringen",
"497182", "Welzheim",
"4936644", "Hirschberg\ Saale",
"492721", "Lennestadt",
"4937432", "Pausa\ Vogtland",
"496039", "Karben",
"4939924", "Stuer",
"497775", "Mühlingen",
"494238", "Neddenaverbergen",
"495067", "Bockenem",
"4934446", "Grosskorbetha",
"495743", "Espelkamp\-Gestringen",
"497685", "Gutach\-Bleibach",
"497668", "Ihringen",
"4938827", "Kalkhorst",
"498323", "Immenstadt\ im\ Allgäu",
"495255", "Altenbeken",
"4939389", "Schollene",
"496484", "Beselich",
"497773", "Bodman\-Ludwigshafen",
"496359", "Grünstadt",
"495608", "Söhrewald",
"498457", "Vohburg\ an\ der\ Donau",
"495137", "Seelze",
"493771", "Aue\ Sachsen",
"498054", "Breitbrunn\ am\ Chiemsee",
"4939244", "Steutz",
"496087", "Waldems",
"496150", "Weiterstadt",
"498771", "Ergoldsbach",
"495947", "Laar\ Vechte",
"496174", "Königstein\ im\ Taunus",
"4934422", "Osterfeld",
"495555", "Moringen\-Fredelsloh",
"496102", "Neu\-Isenburg",
"4938458", "Zehna",
"497321", "Heidenheim\ an\ der\ Brenz",
"494339", "Christiansholm",
"499548", "Mühlhausen\ Mittelfranken",
"499421", "Straubing",
"497977", "Oberrot\ bei\ Gaildorf",
"492375", "Balve",
"499349", "Werbach\-Wenkheim",
"4937207", "Hainichen\ Sachsen",
"495442", "Barnstorf\ Kreis\ Diepholz",
"493334", "Eberswalde",
"495464", "Alfhausen",
"494761", "Bremervörde",
"497449", "Baiersbronn\-Obertal",
"498334", "Bad\ Grönenbach",
"499372", "Klingenberg\ am\ Main",
"4933768", "Prieros",
"4935478", "Goyatz",
"495857", "Bleckede\-Brackede",
"497472", "Rottenburg\ am\ Neckar",
"498681", "Waging\ am\ See",
"492373", "Menden\ Sauerland",
"497404", "Epfendorf",
"493681", "Suhl",
"499326", "Markt\ Einersheim",
"496258", "Gernsheim",
"492584", "Warendorf\-Milte",
"495553", "Kalefeld",
"497426", "Gosheim",
"4938843", "Bennin",
"492166", "Mönchengladbach\-Rheydt",
"495276", "Marienmünster",
"498032", "Rohrdorf\ Kreis\ Rosenheim",
"497229", "Iffezheim",
"499187", "Altdorf\ bei\ Nürnberg",
"495222", "Bad\ Salzuflen",
"494231", "Verden\ Aller",
"499074", "Höchstädt\ an\ der\ Donau",
"498093", "Glonn\ Kreis\ Ebersberg",
"497246", "Malsch\ Kreis\ Karlsruhe",
"494340", "Achterwehr",
"492687", "Horhausen\ Westerwald",
"496551", "Prüm",
"493923", "Zerbst",
"499666", "Illschwang",
"494482", "Hatten",
"4936628", "Zeulenroda",
"496826", "Bexbach",
"495601", "Schauenburg",
"492777", "Breitscheid\ Hessen",
"496804", "Mandelbachtal",
"496872", "Losheim\ am\ See",
"4933924", "Rägelin",
"495594", "Bovenden\-Reyershausen",
"4933334", "Greiffenberg",
"497661", "Kirchzarten",
"4935246", "Ziegenhain\ Sachsen",
"499241", "Pegnitz",
"4933676", "Friedland\ bei\ Beeskow",
"496849", "Kirkel",
"493925", "Stassfurt",
"4937367", "Lengefeld\ Erzgebirge",
"498095", "Aying",
"497303", "Illertissen",
"492402", "Stolberg\ Rheinland",
"4933203", "Kleinmachnow",
"492474", "Nideggen\-Schmidt",
"499403", "Donaustauf",
"492736", "Burbach\ Siegerl",
"4939053", "Süplingen",
"497582", "Bad\ Buchau",
"4933652", "Neuzelle",
"494607", "Janneby",
"4939740", "Nechlin",
"495824", "Bad\ Bodenteich",
"493433", "Borna\ Stadt",
"495363", "Wolfsburg\-Vorsfelde",
"4935434", "Altdöbern",
"49331", "Potsdam",
"49831", "Kempten\ Allgäu",
"495806", "Barum\ bei\ Bad\ Bevensen",
"496041", "Glauburg",
"496621", "Bad\ Hersfeld",
"496596", "Üdersdorf",
"496158", "Riedstadt",
"498433", "Königsmoos",
"496269", "Gundelsheim\ Württemberg",
"499861", "Rothenburg\ ob\ der\ Tauber",
"4933632", "Hangelsberg",
"498027", "Dietramszell",
"4939033", "Wallstawe",
"495237", "Augustdorf",
"499405", "Bad\ Abbach",
"497305", "Erbach\ Donau",
"496838", "Saarwellingen",
"493647", "Pössneck",
"498435", "Ehekirchen",
"496274", "Waldbrunn\ Odenwald",
"496202", "Schwetzingen",
"4935454", "Uckro",
"4935892", "Horka\ OL",
"495365", "Wolfsburg\-Neindorf",
"493435", "Oschatz",
"493562", "Forst\ Lausitz",
"4936421", "Camburg",
"4934344", "Kohren\-Sahlis",
"494348", "Schönkirchen",
"492641", "Bad\ Neuenahr\-Ahrweiler",
"493886", "Gadebusch",
"493544", "Luckau\ Brandenburg",
"493901", "Salzwedel",
"4939921", "Ankershagen",
"498544", "Eging\ am\ See",
"4939456", "Altenbrak",
"492991", "Marsberg\-Bredelar",
"498562", "Triftern",
"495767", "Warmsen",
"499931", "Plattling",
"4938297", "Moitin",
"496466", "Dautphetal\-Friedensdorf",
"4939325", "Vinzelberg",
"495045", "Springe\-Bennigsen",
"498509", "Ruderting",
"495625", "Naumburg\ Hessen",
"494851", "Marne",
"492599", "Ascheberg\-Herbern",
"497707", "Bräunlingen",
"499141", "Weissenburg\ in\ Bayern",
"4933363", "Altenhof\ Kreis\ Barnim",
"492266", "Lindlar",
"495176", "Edemissen",
"497073", "Ammerbuch",
"4936603", "Weida",
"494504", "Ratekau",
"494941", "Aurich",
"4936252", "Tambach\-Dietharz",
"494131", "Lüneburg",
"497129", "Lichtenstein\ Württemberg",
"499287", "Selb",
"494526", "Ascheberg\ Holstein",
"4939955", "Jürgenstorf",
"497146", "Remseck\ am\ Neckar",
"499338", "Röttingen\ Unterfranken",
"495623", "Edertal",
"495043", "Lauenau",
"497936", "Schrozberg\-Bartenstein",
"496361", "Rockenhausen",
"494249", "Bassum\-Nordwohlde",
"495965", "Klein\ Berssen",
"496151", "Darmstadt",
"496628", "Oberaula",
"496048", "Büdingen\-Eckartshausen",
"498754", "Volkenschwand",
"499420", "Feldkirchen\ Niederbayern",
"4939241", "Leitzkau",
"497905", "Langenburg",
"494272", "Siedenburg",
"4934779", "Abberode",
"496787", "Niederbrombach",
"492307", "Kamen",
"494204", "Thedinghausen",
"4935823", "Ostritz",
"492566", "Legden",
"4939061", "Weferlingen",
"498071", "Wasserburg\ am\ Inn",
"49391", "Magdeburg",
"496677", "Neuenstein\ Hessen",
"495963", "Bawinkel",
"495381", "Seesen",
"498262", "Mittelneufnach",
"495634", "Waldeck\-Sachsenhausen",
"499868", "Schillingsfürst",
"4939203", "Barleben",
"497903", "Mainhardt",
"495194", "Bispingen",
"4939882", "Gollin",
"496831", "Saarlouis",
"4933053", "Zehlendorf\ Kreis\ Oberhavel",
"499774", "Oberelsbach",
"499938", "Moos\ Niederbayern",
"496383", "Glan\-Münchweiler",
"496574", "Hasborn",
"494858", "Sankt\ Margarethen\ Holstein",
"4938352", "Kemnitz\ bei\ Greifswald",
"499436", "Nittenau",
"495155", "Emmerthal",
"496502", "Schweich",
"4934328", "Hartha\ bei\ Döbeln",
"494230", "Verden\-Walle",
"499148", "Ettenstatt",
"497336", "Lonsee",
"498406", "Böhmfeld",
"4933436", "Prötzel",
"495833", "Brome",
"4938226", "Dierhagen\ Ostseebad",
"496550", "Irrhausen",
"498732", "Frontenhausen",
"498424", "Nassenfels",
"496569", "Bickendorf",
"496296", "Ahorn\ Baden",
"4934383", "Trebsen\ Mulde",
"497431", "Albstadt\-Ebingen",
"497056", "Gechingen",
"495153", "Salzhemmendorf",
"4933331", "Casekow",
"4938332", "Gross\ Bisdorf",
"499331", "Ochsenfurt",
"496385", "Reichenbach\-Steegen",
"4939363", "Angern",
"493301", "Oranienburg",
"494948", "Wiesmoor\-Marcardsmoor",
"497660", "St\ Peter\ Schwarzwald",
"495652", "Bad\ Sooden\-Allendorf",
"494138", "Betzendorf\ Kreis\ Lüneburg",
"492391", "Plettenberg",
"495835", "Wahrenholz",
"4933456", "Wriezen",
"494446", "Bakum\ Kreis\ Vechta",
"4933921", "Zechlinerhütte",
"499779", "Nordheim\ von\ der\ Rhön",
"498446", "Pörnbach",
"496453", "Gemünden\ Wohra",
"498138", "Schwabhausen\ bei\ Dachau",
"492608", "Welschneudorf",
"4936205", "Gräfenroda",
"4935364", "Lebusa",
"497081", "Bad\ Wildbad",
"4937298", "Oelsnitz\ Erzgebirge",
"4939887", "Gerswalde",
"4935826", "Königshain\ bei\ Görlitz",
"499742", "Kalbach\ Rhön",
"496327", "Neustadt\-Lachen",
"4937468", "Treuen\ Vogtland",
"494795", "Garlstedt",
"499764", "Höchheim",
"492743", "Daaden",
"496542", "Bullay",
"496564", "Neuerburg\ Eifel",
"492255", "Euskirchen\-Flamersheim",
"493341", "Strausberg",
"499086", "Fremdingen",
"4939206", "Eichenbarleben",
"494732", "Stadland\-Rodenkirchen",
"495721", "Stadthagen",
"496455", "Frankenau\ Hessen",
"4933056", "Mühlenbeck\ Kreis\ Oberhavel",
"498341", "Kaufbeuren",
"494406", "Berne",
"498230", "Gablingen",
"492253", "Bad\ Münstereifel",
"495284", "Schwalenberg",
"498858", "Kochel\-Walchensee",
"499252", "Helmbrechts",
"492745", "Brachbach\ Sieg",
"497654", "Löffingen",
"494793", "Hambergen",
"495356", "Helmstedt\-Barmke",
"4933433", "Buckow\ Märkische\ Schweiz",
"4933848", "Raben",
"492522", "Oelde",
"497135", "Brackenheim",
"4936961", "Bad\ Liebenstein",
"4938223", "Saal\ Vorpom",
"499523", "Hofheim\ in\ Unterfranken",
"497945", "Wüstenrot",
"499827", "Lichtenau\ Mittelfranken",
"494244", "Harpstedt",
"498061", "Bad\ Aibling",
"494262", "Visselhövede",
"496723", "Oestrich\-Winkel",
"49491", "Leer\ Ostfriesland",
"497557", "Herdwangen\-Schönach",
"4935204", "Wilsdruff",
"4939291", "Calbe\ Saale",
"494209", "Schwanewede",
"497853", "Kehl\-Bodersweier",
"496008", "Echzell",
"495975", "Rheine\-Mesum",
"492294", "Morsbach\ Sieg",
"496725", "Gau\-Algesheim",
"496186", "Grosskrotzenburg",
"498272", "Wertingen",
"497943", "Schöntal\ Jagst",
"498204", "Mickhausen",
"499525", "Königsberg\ in\ Bayern",
"495036", "Neustadt\-Schneeren",
"49911", "Nuremberg",
"497133", "Lauffen\ am\ Neckar",
"4939752", "Blumenhagen\ bei\ Strasburg",
"495451", "Ibbenbüren",
"494754", "Bülkau",
"498226", "Bibertal",
"4933605", "Boossen",
"4936949", "Obermassfeld\-Grimmenthal",
"495973", "Neuenkirchen\ Kreis\ Steinfurt",
"494770", "Wischhafen",
"4934386", "Dürrweitzschen\ bei\ Grimma",
"49261", "Koblenz\ am\ Rhein",
"497192", "Murrhardt",
"496667", "Steinau\-Ulmbach",
"497632", "Badenweiler",
"495199", "Schneverdingen\-Heber",
"498249", "Ettringen\ Wertach",
"4939366", "Kehnert",
"4939824", "Hohenzieritz",
"499234", "Neusorg",
"499534", "Burgpreppach",
"496476", "Mengerskirchen",
"4936691", "Eisenberg\ Thüringen",
"496422", "Kirchhain",
"496734", "Flonheim",
"498549", "Vilshofen\-Pleinting",
"497747", "Berau",
"499101", "Langenzenn",
"4936021", "Schlotheim",
"4933206", "Fichtenwalde",
"4936741", "Bad\ Blankenburg",
"494308", "Schwedeneck",
"492601", "Nauort",
"499225", "Stadtsteinach",
"4933637", "Beerfelde",
"493504", "Dippoldiswalde",
"493941", "Halberstadt",
"498131", "Dachau",
"498572", "Tann\ Niederbayern",
"495777", "Diepenau\-Essern",
"4939056", "Klüden",
"498504", "Tittling",
"492594", "Dülmen",
"493691", "Eisenach\ Thüringen",
"498851", "Kochel\ am\ See",
"494509", "Gross\ Grönau",
"4938305", "Gingst",
"497257", "Bruchsal\-Untergrombach",
"497124", "Trochtelfingen\ Hohenz",
"496371", "Landstuhl",
"494562", "Grömitz",
"4936703", "Gräfenthal",
"4939036", "Binde",
"495166", "Walsrode\-Kirchboitzen",
"494544", "Berkenthin",
"497063", "Bad\ Wimpfen",
"4933657", "Steinsdorf\ Brandenburg",
"499223", "Rugendorf",
"492222", "Bornheim\ Rheinland",
"498348", "Bidingen",
"492857", "Rees\-Mehr",
"496752", "Kirn\ Nahe",
"495373", "Hillerse\ Kreis\ Gifhorn",
"495584", "Hattorf\ am\ Harz",
"499552", "Burghaslach",
"495846", "Gartow\ Niedersachsen",
"4933366", "Chorin",
"4936330", "Grossberndten",
"494435", "Grossenkneten",
"492553", "Ochtrup",
"497343", "Buch\ bei\ Illertissen",
"495829", "Wriedel",
"4936920", "Grossenlupnitz",
"499443", "Abensberg",
"497822", "Ettenheim",
"492464", "Aldenhoven\ bei\ Jülich",
"4939605", "Gross\ Nemerow",
"498085", "Sankt\ Wolfgang",
"4939453", "Derenburg",
"4938751", "Picher",
"4936257", "Luisenthal\ Thüringen",
"492555", "Schöppingen",
"496264", "Neudenau",
"4938292", "Kröpelin",
"494433", "Dötlingen",
"49431", "Kiel",
"496242", "Osthofen",
"495375", "Müden\ Aller",
"499637", "Falkenberg\ Oberpfalz",
"4935054", "Lauenstein\ Sachsen",
"499197", "Egloffstein",
"492137", "Neuss\-Norf",
"499871", "Windsbach",
"4936606", "Kraftsdorf",
"492697", "Blankenheim\-Ahrhütte",
"4938731", "Lübz",
"4933732", "Hennickendorf\ bei\ Luckenwalde",
"498083", "Isen",
"495956", "Rastdorf",
"4938462", "Baumgarten",
"499445", "Neustadt\ an\ der\ Donau",
"4935842", "Oderwitz",
"494492", "Saterland",
"4935771", "Bad\ Muskau",
"4938725", "Gross\ Godems",
"492947", "Anröchte",
"497345", "Langenau\ Württemberg",
"495458", "Hopsten",
"493987", "Templin",
"499622", "Hirschau\ Oberpfalz",
"492623", "Ransbach\-Baumbach",
"492043", "Gladbeck",
"497224", "Gernsbach",
"499676", "Winklarn",
"494925", "Hinte",
"497157", "Waldenbuch",
"4939998", "Loitz\ bei\ Demmin",
"495266", "Lemgo\-Kirchheide",
"4937202", "Claussnitz\ bei\ Chemnitz",
"4935361", "Schlieben",
"494352", "Damp",
"499123", "Lauf\ an\ der\ Pegnitz",
"497671", "Todtnau",
"4936783", "Gehren\ Thüringen",
"494923", "Krummhörn\-Pewsum",
"499201", "Gesees",
"4933982", "Hoppenrade\ Kreis\ Prignitz",
"496809", "Grossrosseln",
"492045", "Bottrop\-Kirchhellen",
"492625", "Ochtendung",
"498340", "Baisweil",
"49951", "Bamberg",
"498231", "Königsbrunn\ bei\ Augsburg",
"497533", "Allensbach",
"495641", "Warburg",
"495021", "Nienburg\ Weser",
"496844", "Blieskastel\-Altheim",
"496586", "Beuren\ Hochwald",
"49671", "Bad\ Kreuznach",
"497837", "Oberharmersbach",
"496142", "Rüsselsheim",
"4934742", "Sylda",
"496164", "Reichelsheim\ Odenwald",
"4939294", "Gross\ Rosenburg",
"4935201", "Langebrück",
"4937362", "Seiffen\ Erzgebirge",
"4939855", "Parmen\-Weggun",
"494681", "Wyk\ auf\ Föhr",
"497967", "Jagstzell",
"492365", "Marl",
"496708", "Bad\ Münster\ am\ Stein\-Ebernburg",
"492388", "Hamm\-Uentrop",
"494334", "Bredenbek\ bei\ Rendsburg",
"4936964", "Dermbach\ Rhön",
"492237", "Kerpen\ Rheinland\-Türnich",
"493761", "Werdau\ Sachsen",
"4934692", "Alsleben\ Saale",
"4936379", "Holzengel",
"498761", "Moosburg\ an\ der\ Isar",
"498656", "Anger",
"498538", "Pocking\-Hartkirchen",
"4937756", "Breitenbrunn\ Erzgebirge",
"496023", "Alzenau\ in\ Unterfranken",
"496643", "Herbstein",
"495907", "Geeste",
"492824", "Kalkar",
"492363", "Datteln",
"497462", "Immendingen",
"499344", "Gerchsheim",
"4935243", "Weinböhla",
"497444", "Alpirsbach",
"4933673", "Weichensdorf",
"492981", "Winterberg\ Westfalen",
"4939821", "Carpin",
"496645", "Ulrichstein",
"495474", "Stemwede\-Dielingen",
"494771", "Hemmoor",
"495402", "Bissendorf\ Kreis\ Osnabrück",
"4936744", "Remda",
"4936024", "Diedorf\ bei\ Mühlhausen",
"497765", "Rickenbach\ Hotzenwald",
"492835", "Issum",
"492652", "Mendig",
"499653", "Eslarn",
"495184", "Freden\ Leine",
"4935930", "Seitschen",
"494323", "Bornhöved",
"499152", "Hartenstein\ Mittelfranken",
"494864", "Oldenswort",
"4936694", "Schkölen\ Thüringen",
"494842", "Nordstrand",
"4936482", "Triptis",
"492153", "Nettetal\-Lobberich",
"496034", "Wöllstadt",
"495705", "Petershagen\-Windheim",
"4939776", "Hintersee",
"497627", "Steinen\ Kreis\ Lörrach",
"499655", "Tännesberg",
"498238", "Gessertshausen",
"493869", "Dümmer",
"499832", "Wassertrüdingen",
"495028", "Pennigsehl",
"4934496", "Nöbdenitz",
"495648", "Brakel\-Gehrden",
"492833", "Kerken",
"497763", "Murg",
"494952", "Rhauderfehn",
"4938373", "Katzow",
"498869", "Kinsau",
"495703", "Hille",
"493874", "Ludwigslust",
"498802", "Huglfing",
"498387", "Weiler\-Simmerberg",
"499208", "Bindlach",
"4933477", "Trebnitz\ bei\ Müncheberg",
"492634", "Rengsdorf",
"493531", "Finsterwalde",
"498104", "Sauerlach",
"496286", "Walldürn\-Rippberg",
"4938754", "Leussow\ bei\ Ludwigslust",
"498785", "Rottenburg\-Oberroning",
"4935695", "Simmersdorf",
"497233", "Niefern\-Öschelbronn",
"496395", "Münchweiler\ an\ der\ Rodalb",
"49921", "Bayreuth",
"498531", "Pocking",
"4933835", "Golzow\ bei\ Brandenburg",
"499962", "Schwarzach\ Niederbayern",
"496052", "Bad\ Orb",
"4938789", "Wolfshagen\ bei\ Perleberg",
"499944", "Miltach",
"492963", "Brilon\-Messinghausen",
"499134", "Neunkirchen\ am\ Brand",
"4938822", "Diedrichshagen\ bei\ Grevesmühlen",
"494665", "Emmelsbüll\-Horsbüll",
"492381", "Hamm\ Westfalen",
"496701", "Sprendlingen\ Rheinhessen",
"4935025", "Liebstadt",
"496393", "Fischbach\ bei\ Dahn",
"494778", "Wingst",
"497235", "Unterreichenbach\ Kreis\ Calw",
"494934", "Marienhafe",
"4937437", "Bad\ Elster",
"498783", "Rohr\ in\ Niederbayern",
"499854", "Wittelshofen",
"495307", "Braunschweig\-Wenden",
"494162", "Jork",
"4935774", "Boxberg\ Sachsen",
"495882", "Gorleben",
"494144", "Himmelpforten",
"492486", "Nettersheim",
"4936087", "Wüstheuterode",
"494663", "Süderlügum",
"497524", "Bad\ Waldsee",
"4934443", "Teuchern",
"496332", "Zweibrücken",
"497367", "Aalen\-Ebnat",
"497506", "Wangen\-Leupolz",
"4938208", "Kavelstorf",
"493675", "Sonneberg\ Thüringen",
"499467", "Michelsneukirchen",
"494109", "Tangstedt\ Bz\ Hamburg",
"499535", "Pfarrweisach",
"4936074", "Worbis",
"495026", "Steimbke",
"497123", "Metzingen\ Württemberg",
"495646", "Willebadessen",
"494452", "Zetel\-Neuenburg",
"498236", "Fischach",
"496735", "Eppelsheim",
"492657", "Uersfeld",
"495072", "Neustadt\-Mandelsloh",
"496581", "Saarburg",
"499157", "Alfeld\ Mittelfranken",
"4939266", "Förderstedt",
"499080", "Harburg\ Schwaben",
"497676", "Feldberg\ Schwarzwald",
"494847", "Oster\-Ohrstedt",
"49906", "Donauwörth",
"4939726", "Ducherow",
"494543", "Nusse",
"498505", "Hutthurm",
"492595", "Olfen",
"499206", "Mistelgau\-Obernsees",
"497622", "Schopfheim",
"497042", "Vaihingen\ an\ der\ Enz",
"499837", "Haundorf",
"492171", "Leverkusen\-Opladen",
"495261", "Lemgo",
"496733", "Gau\-Odernheim",
"494957", "Detern",
"492532", "Ostbevern",
"497125", "Bad\ Urach",
"4938323", "Prohn",
"49751", "Ravensburg",
"499533", "Untermerzbach",
"4939995", "Nossendorf",
"4936462", "Ossmannstedt",
"492593", "Ascheberg\ Westfalen",
"4934776", "Rothenschirmbach",
"498503", "Neuhaus\ am\ Inn",
"493382", "Lehnin",
"494545", "Seedorf\ Lauenburg",
"4935973", "Stolpen",
"498382", "Lindau\ Bodensee",
"498807", "Diessen\ am\ Ammersee",
"499671", "Oberviechtach",
"4936731", "Unterloquitz",
"4939391", "Lückstedt",
"498177", "Münsing\ Starnberger\ See",
"494776", "Osten\-Altendorf",
"495585", "Herzberg\-Sieber",
"494722", "Cuxhaven\-Altenbruch",
"494434", "Colnrade",
"495731", "Bad\ Oeynhausen",
"496263", "Neckargerach",
"4936943", "Bettenhausen\ Thüringen",
"496057", "Flörsbachtal",
"492465", "Inden",
"498084", "Taufkirchen\ Vils",
"4938872", "Rehna",
"4933742", "Oehna\ Brandenburg",
"492801", "Xanten",
"496265", "Billigheim\ Baden",
"492554", "Laer\ Kreis\ Steinfurt",
"4935264", "Strehla",
"495583", "Braunlage\-Hohegeiss",
"495374", "Isenbüttel",
"499409", "Pielenhofen",
"4935724", "Lohsa",
"495302", "Vechelde",
"494167", "Apensen",
"498766", "Gammelsdorf",
"498651", "Bad\ Reichenhall",
"497309", "Weissenhorn",
"4934673", "Heldrungen",
"4939858", "Bietikow",
"497362", "Bopfingen",
"4938229", "Bad\ Sülze",
"4939401", "Neuwegersleben",
"492463", "Titz",
"499444", "Siegenburg",
"496337", "Grossbundenbach",
"499462", "Falkenstein\ Oberpfalz",
"4933439", "Fredersdorf\-Vogelsdorf",
"497344", "Blaubeuren",
"499627", "Freudenberg\ Oberpfalz",
"4936927", "Unterellen",
"4938392", "Sassnitz",
"494423", "Fedderwarden",
"495159", "Coppenbrügge\-Bisperode",
"4939427", "Ströbeck",
"4933962", "Heiligengrabe",
"497152", "Leonberg\ Württemberg",
"495491", "Damme\ Dümmer",
"494794", "Worpswede\-Ostersode",
"497653", "Lenzkirch",
"499765", "Trappstadt",
"4936337", "Schiedungen",
"495283", "Lügde\-Rischenau",
"492254", "Weilerswist",
"496588", "Pluwig",
"494357", "Sehestedt\ Eider",
"496565", "Dudeldorf",
"494425", "Wangerland\-Hooksiel",
"496454", "Lichtenfels\-Sachsenberg",
"4937604", "Mosel",
"496563", "Kyllburg",
"495285", "Bad\ Pyrmont\-Kleinenberg",
"492744", "Herdorf",
"499763", "Sulzdorf\ an\ der\ Lederhecke",
"495839", "Wittingen\-Ohrdorf",
"49281", "Wesel",
"496867", "Perl",
"497655", "Feldberg\-Altglashütten",
"497832", "Haslach\ im\ Kinzigtal",
"492762", "Wenden\ Südsauerland",
"494753", "Balje",
"4938205", "Tessin\ bei\ Rostock",
"496147", "Trebur",
"497134", "Weinsberg",
"497944", "Kupferzell",
"498203", "Grossaitingen",
"499292", "Konradsreuth",
"494245", "Neuenkirchen\ bei\ Bassum",
"497962", "Fichtenau",
"492293", "Nümbrecht",
"499233", "Arzberg\ Oberfranken",
"49721", "Karlsruhe",
"492232", "Brühl\ Rheinland",
"495561", "Einbeck",
"495902", "Freren",
"496724", "Stromberg\ Hunsrück",
"496432", "Diez",
"4935028", "Krippen",
"492295", "Ruppichteroth",
"497467", "Neuhausen\ ob\ Eck",
"494243", "Twistringen",
"4939459", "Hasselfelde",
"499367", "Unterpleichfeld",
"498205", "Dasing",
"499524", "Zeil\ am\ Main",
"496706", "Wallhausen\ Nahe",
"4934294", "Rackwitz",
"4939742", "Brüssow\ bei\ Pasewalk",
"4933838", "Päwesin",
"4937382", "Geringswalde",
"494755", "Ihlienworth",
"495407", "Wallenhorst",
"496281", "Buchen\ Odenwald",
"4934464", "Freyburg\ Unstrut",
"497854", "Kehl\-Goldscheuer",
"4935698", "Hornow",
"498536", "Kösslarn",
"4939484", "Harzgerode",
"495840", "Schnackenburg",
"499235", "Thierstein",
"4933093", "Fürstenberg\ Havel",
"498121", "Markt\ Schwaben",
"492834", "Straelen",
"497764", "Herrischried",
"496427", "Cölbe\-Schönstadt",
"493329", "Stahnsdorf",
"496580", "Zemmer",
"4935343", "Hirschfeld\ bei\ Elsterwerda",
"497742", "Klettgau",
"495168", "Walsrode\-Stellichte",
"495185", "Duingen",
"4936071", "Teistungen",
"495726", "Wiedensahl",
"494865", "Osterhever",
"493346", "Seelow",
"499081", "Nördlingen",
"494401", "Brake\ Unterweser",
"498346", "Pforzen",
"496035", "Reichelsheim\ Wetterau",
"495772", "Espelkamp",
"495704", "Petershagen\-Friedewalde",
"496353", "Freinsheim",
"499654", "Pleystein",
"495682", "Borken\ Hessen",
"496478", "Greifenstein\-Ulm",
"497252", "Bretten",
"4939394", "Hohenberg\-Krusemark",
"496092", "Heimbuchenthal",
"4937465", "Tannenbergsthal\ Vogtland",
"495259", "Bad\ Driburg\-Neuenheerse",
"4936734", "Leutenberg",
"496355", "Albisheim\ Pfrimm",
"4936208", "Ermstedt",
"498441", "Pfaffenhofen\ an\ der\ Ilm",
"496033", "Butzbach",
"4937295", "Lugau\ Erzgebirge",
"493441", "Zeitz",
"493528", "Radeberg",
"492154", "Willich",
"494324", "Brokstedt",
"492227", "Bornheim\-Merten",
"494863", "Sankt\ Peter\-Ording",
"495183", "Lamspringe",
"494143", "Drochtersen",
"496757", "Becherbach\ bei\ Kirn",
"492635", "Rheinbrohl",
"498105", "Gilching",
"492852", "Hamminkeln",
"492195", "Radevormwald",
"499853", "Wilburgstetten",
"4933874", "Stechow\ Brandenburg",
"498784", "Hohenthann",
"494933", "Dornum\ Ostfriesland",
"496394", "Bundenthal",
"4933608", "Jacobsdorf\ Mark",
"492447", "Dahlem\ bei\ Kall",
"4933679", "Wendisch\ Rietz",
"499945", "Arnbruck",
"496181", "Hanau",
"495456", "Westerkappeln\-Velpe",
"499135", "Hessdorf\ Mittelfranken",
"4935249", "Basslitz",
"498221", "Günzburg",
"494664", "Neukirchen\ bei\ Niebüll",
"494642", "Kappeln\ Schlei",
"4935755", "Ortrand",
"495031", "Wunstorf",
"4938482", "Warin",
"497234", "Tiefenbronn",
"494935", "Juist",
"496247", "Worms\-Pfeddersheim",
"4936373", "Buttstädt",
"498669", "Traunreut",
"499855", "Dentlein\ am\ Forst",
"499632", "Waldsassen",
"4939404", "Ausleben",
"492193", "Dabringhausen",
"498650", "Marktschellenberg",
"495848", "Trebel",
"492633", "Brohl\-Lützing",
"499192", "Gräfenberg",
"492132", "Meerbusch\-Büderich",
"497525", "Aulendorf",
"495351", "Helmstedt",
"492692", "Kelberg",
"49711", "Stuttgart",
"499133", "Baiersdorf\ Mittelfranken",
"4934605", "Gröbers",
"492964", "Brilon\-Alme",
"494497", "Barssel\-Harkebrügge",
"499943", "Lam\ Oberpfalz",
"492571", "Greven\ Westfalen",
"498066", "Bad\ Feilnbach",
"4933845", "Borkheide",
"492942", "Geseke",
"494881", "Friedrichstadt",
"492271", "Bergheim\ Erft",
"495161", "Walsrode",
"499088", "Mönchsdeggingen",
"497225", "Gaggenau",
"494924", "Moormerland\-Oldersum",
"4934206", "Rötha",
"494408", "Hude\ Oldenburg",
"4935876", "Weissenberg\ Sachsen",
"4934637", "Frankleben",
"496322", "Bad\ Dürkheim",
"499747", "Geroda\ Bayern",
"4938379", "Benz\ Usedom",
"498856", "Penzberg",
"4938308", "Göhren\ Rügen",
"496843", "Gersheim",
"4933394", "Blumberg\ Kreis\ Barnim",
"497534", "Reichenau\ Baden",
"4937423", "Adorf\ Vogtland",
"492606", "Winningen\ Mosel",
"498136", "Markt\ Indersdorf",
"493946", "Quedlinburg",
"497223", "Bühl\ Baden",
"494737", "Stadland\-Schwei",
"492624", "Höhr\-Grenzhausen",
"493521", "Meissen",
"493448", "Meuselwitz\ Thüringen",
"4938856", "Pritzier\ bei\ Hagenow",
"4935384", "Steinsdorf\ bei\ Jessen",
"4937430", "Eichigt",
"499257", "Zell\ Oberfranken",
"496471", "Weilburg",
"4937601", "Mülsen\ Skt\ Jacob",
"499106", "Markt\ Erlbach",
"492527", "Lippetal\-Lippborg",
"4938728", "Domsühl",
"499876", "Rohr\ Mittelfranken",
"495951", "Werlte",
"496188", "Kahl\ am\ Main",
"496165", "Breuberg",
"4935937", "Prischwitz",
"497443", "Dornstetten",
"499822", "Bechhofen\ an\ der\ Heide",
"499343", "Lauda\-Königshofen",
"492823", "Goch",
"494267", "Lauenbrück",
"492364", "Haltern\ Westfalen",
"494335", "Hohn\ bei\ Rendsburg",
"497552", "Pfullendorf",
"492379", "Menden\-Asbeck",
"4939386", "Seehausen\ Altmark",
"4935327", "Priessen",
"495473", "Ostercappeln",
"492825", "Uedem",
"4934461", "Nebra\ Unstrut",
"494392", "Nortorf\ bei\ Neumünster",
"499345", "Külsheim\ Baden",
"4939608", "Staven",
"4936846", "Suhl\-Dietzhausen",
"495358", "Bahrdorf\-Mackendorf",
"497445", "Pfalzgrafenweiler",
"4933470", "Lietzen",
"4939481", "Hedersleben\ bei\ Aschersleben",
"496163", "Höchst\ im\ Odenwald",
"4938783", "Dallmin",
"4935602", "Drebkau",
"495475", "Bohmte\-Hunteburg",
"496024", "Schöllkrippen",
"496644", "Grebenhain",
"4934291", "Borsdorf",
"494333", "Erfde",
"495841", "Lüchow\ Wendland",
"49441", "Oldenburg",
"499491", "Hemau",
"497391", "Ehingen\ Donau",
"495765", "Raddestorf",
"494826", "Hohenlockstedt",
"4933983", "Gross\ Pankow\ Kreis\ Prignitz",
"4934925", "Bad\ Schmiedeberg",
"499283", "Rehau",
"4936782", "Schmiedefeld\ am\ Rennsteig",
"494804", "Nordhastedt",
"494872", "Hanerau\-Hademarschen",
"497705", "Wolterdingen\ Schwarzw",
"4934321", "Leisnig",
"492056", "Heiligenhaus",
"4936624", "Teichwolframsdorf",
"492431", "Erkelenz",
"497184", "Kaisersbach",
"494849", "Hooge",
"494959", "Dollart",
"498586", "Hauzenberg",
"49871", "Landshut",
"499268", "Teuschnitz",
"4939975", "Thürkow",
"4938847", "Boizenburg\ Elbe",
"499285", "Kirchenlamitz",
"498862", "Steingaden\ Oberbayern",
"496231", "Hochdorf\-Assenheim",
"495763", "Uchte",
"493844", "Schwaan",
"4934426", "Kayna",
"4933928", "Wildberg\ Brandenburg",
"499396", "Urspringen\ bei\ Lohr",
"49371", "Chemnitz\ Sachsen",
"493586", "Neugersdorf\ Sachsen",
"498809", "Wessobrunn",
"492336", "Schwelm",
"494551", "Bad\ Segeberg",
"4933338", "Stolpe\/Oder",
"496340", "Wörth\-Schaidt",
"497703", "Bonndorf\ im\ Schwarzwald",
"496482", "Runkel",
"4937203", "Gersdorf\ bei\ Chemnitz",
"496761", "Simmern\ Hunsrück",
"495233", "Steinheim\ Westfalen",
"496656", "Ebersburg",
"4939248", "Dobritz",
"494605", "Medelby",
"4933672", "Pfaffendorfb\ Beeskow",
"498023", "Bayrischzell",
"498179", "Eurasburg\ an\ der\ Loisach",
"492903", "Meschede\-Freienohl",
"499561", "Coburg",
"4935242", "Nossen",
"493643", "Weimar\ Thüringen",
"499738", "Rottershausen",
"499974", "Traitsching",
"4938454", "Kritzkow",
"4937757", "Rittersgrün",
"498708", "Weihmichl\-Unterneuhausen",
"498142", "Olching",
"496059", "Jossgrund",
"494830", "Süderhastedt",
"495292", "Lichtenau\-Atteln",
"494258", "Schwarme",
"494169", "Sauensiek",
"4933085", "Seilershof",
"499407", "Wenzenbach",
"497566", "Argenbühl",
"497307", "Senden\ Iller",
"492905", "Bestwig\-Ramsbeck",
"4937363", "Zöblitz",
"498025", "Miesbach",
"494603", "Havetoft",
"495235", "Blomberg\ Lippe",
"4934743", "Ermsleben",
"4933764", "Mittenwalde\ Mark",
"496339", "Grosssteinhausen",
"495506", "Adelebsen",
"4935474", "Schönwalde\ bei\ Lübben",
"494174", "Stelle\ Kreis\ Harburg",
"493437", "Grimma",
"495367", "Rühen",
"494102", "Ahrensburg",
"495524", "Bad\ Lauterberg\ im\ Harz",
"494748", "Stubben\ bei\ Bremerhaven",
"498034", "Brannenburg",
"495157", "Emmerthal\-Börry",
"4938372", "Usedom",
"495224", "Enger\ Westfalen",
"495206", "Bielefeld\-Jöllenbeck",
"496130", "Schwabenheim\ an\ der\ Selz",
"495535", "Polle",
"499646", "Freihung",
"4939777", "Borkenfriede",
"4936428", "Stadtroda",
"499498", "Laaber",
"492129", "Haan\ Rheinland",
"4933975", "Dannenwalde\ Kreis\ Prignitz",
"494484", "Hude\-Wüsting",
"4936648", "Dittersdorf\ bei\ Schleiz",
"499072", "Lauingen\ Donau",
"4939928", "Möllenhagen",
"497266", "Kirchardt",
"496802", "Völklingen\-Lauterbach",
"496874", "Wadern\-Nunkirchen",
"494558", "Todesfelde",
"49345", "Halle\ Saale",
"496387", "Sankt\ Julian",
"494636", "Langballig",
"495592", "Gleichen\-Bremke",
"497720", "Schwenningen\ am\ Neckar",
"495671", "Hofgeismar",
"4934497", "Langenleuba\-Niederhain",
"495837", "Sprakensehl",
"4934909", "Aken\ Elbe",
"498370", "Wiggensbach",
"4934978", "Radegast\ Kreis\ Köthen",
"4933476", "Neuhardenberg",
"499261", "Kronach",
"496869", "Merzig\-Silwingen",
"4936483", "Ziegenrück",
"496238", "Dirmstein",
"497021", "Kirchheim\ unter\ Teck",
"4936840", "Trusetal",
"497641", "Emmendingen",
"495533", "Bodenwerder",
"496673", "Haunetal",
"498052", "Aschau\ im\ Chiemgau",
"494251", "Hoya",
"4939224", "Büden",
"492305", "Castrop\-Rauxel",
"496785", "Herrstein",
"497907", "Schwäbisch\ Hall\-Sulzdorf",
"496126", "Idstein",
"4939085", "Zichtau",
"4937325", "Niederbobritzsch",
"496531", "Bernkastel\-Kues",
"498395", "Tannheim\ Württemberg",
"496172", "Bad\ Homburg\ von\ der\ Höhe",
"499568", "Neustadt\ bei\ Coburg",
"493395", "Pritzwalk",
"496104", "Heusenstamm",
"498332", "Ottobeuren",
"499350", "Eussenheim\-Hundsbach",
"494741", "Nordholz\ bei\ Bremerhaven",
"495444", "Wagenfeld",
"4937436", "Weischlitz",
"496675", "Breitenbach\ am\ Herzberg",
"495462", "Ankum",
"493332", "Schwedt\/Oder",
"499369", "Uettingen",
"492582", "Everswinkel",
"4938850", "Gammelin",
"4938823", "Selmsdorf",
"492866", "Dorsten\-Rhade",
"497736", "Tengen",
"498393", "Holzgünz",
"499374", "Eschau",
"499302", "Rottendorf\ Unterfranken",
"495409", "Hilter\ am\ Teutoburger\ Wald",
"4935609", "Drachhausen",
"497474", "Haigerloch",
"497402", "Fluorn\-Winzeln",
"492303", "Unna",
"496783", "Baumholder",
"496429", "Schweinsberg\ Hessen",
"498542", "Ortenburg",
"498564", "Johanniskirchen",
"494296", "Schwanewede\-Aschwarden",
"4939886", "Milmersdorf",
"493327", "Werder\ Havel",
"4935827", "Nieder\-Seifersdorf",
"493564", "Schwarze\ Pumpe",
"498327", "Rettenberg",
"4934324", "Ostrau\ Sachsen",
"492661", "Bad\ Marienberg\ Westerwald",
"493971", "Anklam",
"494385", "Hohenfelde\ bei\ Kiel",
"4936621", "Elsterberg\ bei\ Plauen",
"493542", "Lübbenau\ Spreewald",
"4939345", "Parchen",
"499161", "Neustadt\ an\ der\ Aisch",
"495065", "Sibbesse",
"497777", "Sauldorf",
"496446", "Hohenahr",
"496698", "Schrecksbach",
"498453", "Reichertshofen\ Oberbayern",
"496138", "Mommenheim",
"494383", "Grebin",
"495257", "Hövelhof",
"498378", "Buchenberg\ bei\ Kempten",
"493378", "Ludwigsfelde",
"494961", "Papenburg",
"496858", "Ottweiler\-Fürth",
"4939207", "Colbitz",
"492246", "Lohmar\ Rheinland",
"494502", "Lübeck\-Travemünde",
"494550", "Bühnsdorf",
"496341", "Landau\ in\ der\ Pfalz",
"497728", "Niedereschach",
"495063", "Bad\ Salzdetfurth",
"497166", "Adelberg",
"4934954", "Roitzsch\ bei\ Bitterfeld",
"492426", "Nörvenich",
"4938451", "Hoppenrade\ bei\ Güstrow",
"4933452", "Neulewin",
"4939753", "Strasburg",
"493494", "Wolfen",
"497584", "Altshausen",
"4939005", "Kusey",
"492404", "Alsdorf\ Rheinland",
"499560", "Grub\ am\ Forst",
"492928", "Soest\-Ostönnen",
"492472", "Monschau",
"497373", "Zwiefalten",
"499473", "Kallmünz",
"496061", "Michelstadt",
"499951", "Landau\ an\ der\ Isar",
"498723", "Arnstorf",
"492449", "Blankenheim\ Ahr",
"493723", "Hohenstein\-Ernstthal",
"495822", "Ebstorf",
"4933235", "Friesack",
"4935471", "Birkenhainchen",
"497375", "Obermarchtal",
"492977", "Schmallenberg\-Bödefeld",
"4938425", "Kirchdorf\ Poel",
"4938222", "Semlow",
"494151", "Schwarzenbek",
"498667", "Seeon\-Seebruck",
"4933432", "Müncheberg",
"499841", "Bad\ Windsheim",
"496249", "Guntersblum",
"494499", "Barssel",
"495345", "Baddeckenstedt",
"497458", "Ebhausen",
"4938356", "Behrenhoff",
"493725", "Zschopau",
"499358", "Gössenheim",
"496226", "Meckesheim",
"498725", "Wurmannsquick",
"496272", "Hirschhorn\ Neckar",
"496204", "Viernheim",
"499185", "Mühlhausen\ Oberpfalz",
"496572", "Manderscheid\ Eifel",
"4934348", "Frohburg",
"499726", "Euerbach",
"496504", "Thalfang",
"499772", "Bischofsheim\ an\ der\ Rhön",
"496526", "Bollendorf",
"499704", "Euerdorf",
"496691", "Schwalmstadt",
"492773", "Haiger",
"496131", "Mainz",
"498734", "Reisbach\ Niederbayern",
"498422", "Dollnstein",
"4939057", "Rätzlingen\ Sachsen\-Anhalt",
"493476", "Hettstedt\ Sachsen\-Anhalt",
"492685", "Flammersfeld",
"4933207", "Gross\ Kreutz",
"499749", "Oberbach\ Unterfranken",
"4933636", "Steinhöfel\ Kreis\ Oder\-Spree",
"4936702", "Lauscha",
"4933969", "Stepenitz",
"494361", "Oldenburg\ in\ Holstein",
"492775", "Driedorf",
"496348", "Offenbach\ an\ der\ Queich",
"497721", "Villingen\ im\ Schwarzwald",
"492182", "Grevenbroich\-Kapellen",
"499183", "Burgthann",
"495654", "Herleshausen",
"499682", "Erbendorf",
"494466", "Wittmund\-Ardorf",
"4933656", "Bahro",
"499260", "Wilhelmsthal\ Oberfranken",
"492683", "Asbach\ Westerwald",
"494968", "Neulehe",
"493371", "Luckenwalde",
"4936873", "Themar",
"4939037", "Pretzier",
"496851", "St\ Wendel",
"496068", "Beerfelden",
"496085", "Waldsolms",
"495945", "Wilsum",
"4933367", "Friedrichswalde\ Brandenburg",
"494269", "Ahausen\-Kirchwalsede",
"495135", "Burgwedel\-Fuhrberg",
"492529", "Oelde\-Stromberg",
"494838", "Tellingstedt",
"495695", "Twistetal",
"497356", "Schemmerhofen",
"4938293", "Kühlungsborn\ Ostseebad",
"494274", "Varrel\ bei\ Sulingen",
"492377", "Wickede\ Ruhr",
"497975", "Untergröningen",
"494202", "Achim\ bei\ Bremen",
"492546", "Coesfeld\-Lette",
"4936256", "Wechmar",
"4935843", "Hirschfelde\ bei\ Zittau",
"495853", "Neu\ Darchau",
"498752", "Au\ in\ der\ Hallertau",
"4933733", "Stülpe",
"492921", "Soest",
"4934781", "Greifenhagen",
"4939221", "Möckern\ bei\ Magdeburg",
"497451", "Horb\ am\ Neckar",
"495693", "Volkmarsen",
"499351", "Gemünden\ am\ Main",
"495943", "Emlichheim",
"494740", "Loxstedt\-Dedesdorf",
"496083", "Weilrod",
"4939452", "Ilsenburg",
"494621", "Schleswig",
"495855", "Nahrendorf",
"494158", "Roseburg",
"495632", "Willingen\ Upland",
"499848", "Simmershofen",
"4939749", "Grambow\ bei\ Pasewalk",
"4936607", "Niederpöllnitz",
"497973", "Obersontheim",
"495192", "Munster",
"496346", "Annweiler\ am\ Trifels",
"498035", "Raubling",
"495225", "Spenge",
"492330", "Herdecke",
"4937209", "Einsiedel\ bei\ Chemnitz",
"499777", "Ostheim\ von\ der\ Rhön",
"496873", "Nonnweiler",
"497161", "Göppingen",
"495534", "Eschershausen\ an\ der\ Lenne",
"498427", "Wellheim",
"494468", "Friedeburg\-Reepsholt",
"494485", "Elsfleth\-Huntorf",
"496329", "Weidenthal\ Pfalz",
"492241", "Siegburg",
"495101", "Pattensen",
"494966", "Neubörger",
"4935342", "Mühlberg\ Elbe",
"496875", "Nonnweiler\-Primstal",
"499728", "Wülfershausen\ Unterfranken",
"499166", "Münchsteinach",
"495223", "Bünde",
"4939348", "Klitsche",
"496441", "Wetzlar",
"498033", "Oberaudorf",
"498092", "Grafing\ bei\ München",
"4933989", "Sadenbeck",
"493976", "Torgelow\ bei\ Ueckermünde",
"494483", "Ovelgönne\-Grossenmeer",
"492666", "Freilingen\ Westerwald",
"492751", "Bad\ Berleburg",
"496221", "Heidelberg",
"499829", "Flachslanden",
"495443", "Lemförde",
"4933704", "Baruth\ Mark",
"4936372", "Kleinneuhausen",
"497951", "Crailsheim",
"492304", "Schwerte",
"496784", "Weierbach",
"494207", "Oyten",
"492372", "Hemer",
"497473", "Mössingen",
"499373", "Amorbach",
"498394", "Lautrach",
"4937369", "Wolkenstein",
"4938428", "Hohenkirchen\ bei\ Wismar",
"499846", "Ipsheim",
"496105", "Mörfelden\-Walldorf",
"495552", "Katlenburg",
"493394", "Wittstock\ Dosse",
"494156", "Talkau",
"4933238", "Senzke",
"499956", "Eichendorf\-Aufhausen",
"496066", "Michelstadt\-Vielbrunn",
"496674", "Friedewald\ Hessen",
"495445", "Drebber",
"497358", "Eberhardzell\-Füramoos",
"494836", "Hennstedt\ Dithmarschen",
"4938483", "Brüel",
"4937341", "Ehrenfriedersdorf",
"4934221", "Schildau\ Gneisenaustadt",
"497841", "Achern",
"492421", "Düren",
"496650", "Hosenfeld",
"492548", "Dülmen\-Rorup",
"496103", "Langen\ Hessen",
"499375", "Freudenberg\ Baden",
"4939008", "Kunrau",
"498247", "Bad\ Wörishofen",
"495197", "Soltau\-Frielingen",
"497475", "Burladingen",
"496669", "Neuhof\-Hauswurz",
"498547", "Osterhofen\-Gergweis",
"495742", "Preussisch\ Oldendorf",
"4934207", "Zwochau",
"493843", "Güstrow",
"498376", "Sulzberg\ Allgäu",
"495764", "Steyerberg",
"4935877", "Cunewalde",
"4934636", "Schafstädt",
"493322", "Falkensee",
"494461", "Jever",
"492248", "Hennef\-Uckerath",
"498322", "Oberstdorf",
"496856", "St\ Wendel\-Niederkirchen",
"494805", "Schafstedt",
"4934903", "Coswig\ Anhalt",
"495108", "Gehrden\ Han",
"494630", "Barderup",
"4939954", "Stavenhagen\ Reuterstadt",
"497704", "Geisingen\ Baden",
"4936454", "Magdala",
"497726", "Bad\ Dürrheim",
"498845", "Bad\ Kohlgrub",
"497259", "Östringen\-Odenheim",
"494803", "Pahlen",
"493471", "Bernburg\ Saale",
"494298", "Lilienthal",
"4939324", "Kläden\ bei\ Stendal",
"499284", "Schwarzenbach\ an\ der\ Saale",
"495252", "Bad\ Lippspringe",
"497260", "Sinsheim\-Hilsbach",
"494366", "Grömitz\-Cismar",
"4934656", "Wallhausen\ Sachsen\-Anhalt",
"492758", "Bad\ Berleburg\-Girkhausen",
"497682", "Elzach",
"4937422", "Markneukirchen",
"495086", "Celle\-Scheuen",
"497183", "Rudersberg\ Württemberg",
"499721", "Schweinfurt",
"496136", "Nieder\-Olm",
"4939934", "Gross\ Plasten",
"4934345", "Bad\ Lausick",
"496696", "Gilserberg",
"4935603", "Burg\ Spreewald",
"4938782", "Reetz\ bei\ Perleberg",
"494604", "Grossenwiehe",
"4935455", "Walddrehna",
"494672", "Langenhorn",
"492859", "Wesel\-Bislich",
"494626", "Treia",
"499975", "Waldmünchen\-Geigant",
"4935936", "Sohland\ Spree",
"499356", "Burgsinn",
"496228", "Schönau\ Odenwald",
"497031", "Böblingen",
"4939387", "Havelberg",
"497456", "Haiterbach",
"495523", "Bad\ Sachsa",
"4935326", "Schönborn\ Kreis\ Elbe\-Elster",
"495827", "Unterlüss",
"494173", "Wulfsen",
"497958", "Rot\ Am\ See\-Brettheim",
"498165", "Neufahrn\ bei\ Freising",
"499973", "Furth\ im\ Wald",
"499639", "Mähring",
"493644", "Apolda",
"492972", "Schmallenberg",
"496120", "Aarbergen",
"492541", "Coesfeld",
"499199", "Kunreuth",
"492428", "Niederzier",
"492904", "Bestwig",
"498024", "Holzkirchen",
"4935435", "Gollmitz\ bei\ Calau",
"493994", "Malchin",
"4936847", "Steinbach\-Hallenberg",
"495234", "Horn\-Bad\ Meinberg",
"498662", "Siegsdorf\ Kreis\ Traunstein",
"494175", "Egestorf\ Nordheide",
"497351", "Biberach\ an\ der\ Riss",
"495525", "Walkenried",
"49511", "Hannover",
"499451", "Schierling",
"499184", "Deining\ Oberpfalz",
"4938322", "Richtenberg",
"495152", "Hessisch\ Oldendorf",
"496505", "Kordel",
"494638", "Tarp",
"492331", "Hagen\ Westfalen",
"494556", "Ahrensbök\-Gnissau",
"497159", "Renningen",
"4933335", "Pinnow\ Kreis\ Uckermark",
"49395", "Neubrandenburg",
"4933925", "Wustrau\-Altfriesack",
"4939727", "Spantekow",
"498735", "Gangkofen\-Kollbach",
"498581", "Waldkirchen\ Niederbayern",
"499391", "Marktheidenfeld",
"492684", "Puderbach\ Westerwald",
"4939978", "Gross\ Roge",
"4933931", "Rheinsberg\ Mark",
"493581", "Görlitz",
"4939267", "Schneidlingen",
"499077", "Bachhagel",
"493735", "Marienberg\ Sachsen",
"4936463", "Gebstedt",
"496236", "Neuhofen\ Pfalz",
"495653", "Sontra",
"496382", "Lauterecken",
"492938", "Ense",
"492774", "Dietzhölztal",
"492436", "Wegberg\-Rödgen",
"495208", "Leopoldshöhe",
"496503", "Hermeskeil",
"492051", "Velbert",
"496440", "Kölschhausen",
"494821", "Itzehoe",
"495655", "Wanfried",
"493733", "Annaberg\-Buchholz",
"495832", "Hankensbüttel",
"499648", "Neustadt\ am\ Kulm",
"4934928", "Seegrehna",
"497839", "Schapbach",
"497268", "Bad\ Rappenau\-Obergimpern",
"492750", "Diedenshausen",
"498733", "Mengkofen",
"496084", "Schmitten\ Taunus",
"496220", "Wilhelmsfeld",
"495962", "Herzlake",
"495944", "Hoogstede",
"498057", "Aschau\-Sachrang",
"495694", "Diemelstadt",
"497950", "Schnelldorf",
"497738", "Steisslingen",
"4935820", "Zodel",
"494275", "Ehrenburg",
"497974", "Bühlerzell",
"495909", "Wettrup",
"4933701", "Grossbeeren",
"497561", "Leutkirch\ im\ Allgäu",
"498263", "Breitenbrunn\ Schwaben",
"4933088", "Falkenthal",
"4934672", "Rossleben",
"49521", "Bielefeld",
"4934224", "Belgern\ Sachsen",
"498337", "Altenstadt\ Iller",
"4937344", "Crottendorf\ Sachsen",
"496439", "Holzappel",
"493337", "Biesenthal\ Brandenburg",
"495467", "Voltlage",
"492587", "Ennigerloh\-Westkirchen",
"4933743", "Blönsdorf",
"496128", "Taunusstein",
"4938873", "Carlow",
"496766", "Kisselbach",
"496651", "Rasdorf",
"498265", "Pfaffenhausen\ Schwaben",
"495854", "Bleckede\-Barskamp",
"499307", "Altertheim",
"4939245", "Loburg",
"4939200", "Gommern",
"494273", "Kirchdorf\ bei\ Sulingen",
"499566", "Meeder",
"4939951", "Faulenrost",
"499266", "Mitwitz",
"4939426", "Hessen",
"497072", "Gomaringen",
"498565", "Dietersburg\-Baumgarten",
"493588", "Niesky",
"4936451", "Buttelstedt",
"499398", "Birkenfeld\ bei\ Würzburg",
"4934975", "Görzig\ Kreis\ Köthen",
"4936926", "Creuzburg",
"494384", "Selent",
"494877", "Hennstedt\ bei\ Itzehoe",
"497646", "Weisweil\ Breisgau",
"495123", "Schellerten",
"497026", "Lenningen",
"494631", "Glücksburg\ Ostsee",
"495042", "Bad\ Münder\ am\ Deister",
"495622", "Fritzlar",
"4936336", "Klettenberg",
"495064", "Gross\ Düngen",
"494191", "Kaltenkirchen\ Holstein",
"497629", "Tegernau\ Baden",
"492338", "Breckerfeld",
"495676", "Liebenau\ Hessen",
"4933963", "Wulfersdorf\ bei\ Wittstock",
"494828", "Lägerdorf",
"49551", "Göttingen",
"498867", "Rottenbuch\ Oberbayern",
"4938393", "Binz\ Ostseebad",
"499641", "Grafenwöhr",
"493563", "Spremberg",
"4939925", "Wredenhagen",
"493867", "Lübstorf",
"4936645", "Mühltroff",
"498563", "Bad\ Birnbach\ Rottal",
"4936762", "Steinach\ Thüringen",
"497261", "Sinsheim",
"4933978", "Segeletz",
"4939931", "Röbel\ Müritz",
"4936425", "Isserstedt",
"498389", "Weissensberg",
"498454", "Karlshuld",
"492931", "Arnsberg",
"499720", "Üchtelhausen",
"4939321", "Arneburg",
"495201", "Halle\ Westfalen",
"49335", "Frankfurt\ \(Oder\)",
"492058", "Wülfrath",
"4937383", "Lunzenau",
"497731", "Singen\ Hohentwiel",
"492861", "Borken\ Westfalen",
"4939743", "Zerrenthin",
"4939050", "Bartensleben",
"497585", "Ostrach",
"497568", "Bad\ Wurzach\-Hauerz",
"492405", "Würselen",
"4933200", "Bergholz\-Rehbrücke",
"499907", "Zenting",
"496203", "Ladenburg",
"496898", "Völklingen",
"495508", "Gleichen\-Rittmarshausen",
"493937", "Osterburg\ Altmark",
"494746", "Hagen\ bei\ Bremerhaven",
"499474", "Schmidmühlen",
"499402", "Regenstauf",
"496536", "Kleinich",
"495309", "Lehre\-Wendhausen",
"497374", "Uttenweiler",
"496658", "Poppenhausen\ Wasserkuppe",
"492403", "Eschweiler\ Rheinland",
"497302", "Pfaffenhofen\ an\ der\ Roth",
"498281", "Thannhausen\ Schwaben",
"4939030", "Brunau",
"499736", "Oberthulba",
"497583", "Bad\ Schussenried",
"4937328", "Grossschirma",
"4939088", "Letzlingen",
"493493", "Bitterfeld",
"498706", "Vilsheim",
"495344", "Lengede",
"494107", "Siek\ Kreis\ Stormarn",
"495362", "Wolfsburg\-Fallersleben",
"499469", "Roding\-Neubäu",
"493724", "Burgstädt",
"498432", "Burgheim",
"498724", "Massing",
"494256", "Hilgermissen",
"496205", "Hockenheim",
"499542", "Schesslitz",
"4939265", "Löderburg",
"499971", "Cham",
"4938848", "Vellahn",
"492543", "Billerbeck\ Westfalen",
"496108", "Mühlheim\ am\ Main",
"499564", "Bad\ Rodach",
"4936962", "Vacha",
"496742", "Boppard",
"4933927", "Linum",
"4939000", "Beetzendorf",
"4933763", "Bestensee",
"497427", "Schömberg\ bei\ Balingen",
"496764", "Rheinböllen",
"4935473", "Neu\ Lübbenau",
"498161", "Freising",
"4933337", "Altkünkendorf",
"4939292", "Biederitz",
"492452", "Heinsberg\ Rheinland",
"497353", "Schwendi",
"4937364", "Reitzenhain\ Erzgebirge",
"499453", "Thalmassing",
"497478", "Hirrlingen",
"499378", "Eichenbühl\-Riedern",
"4934775", "Wippra",
"497976", "Sulzbach\-Laufen",
"492545", "Rosendahl\-Darfeld",
"4933230", "Börnicke\ Kreis\ Havelland",
"496252", "Heppenheim\ Bergstrasse",
"4939751", "Penkun",
"4938453", "Mistorf",
"497033", "Weil\ Der\ Stadt",
"495136", "Burgdorf\ Kreis\ Hannover",
"495696", "Bad\ Arolsen\-Landau",
"495521", "Herzberg\ am\ Harz",
"495448", "Barver",
"497355", "Hochdorf\ Riss",
"492957", "Wünnenberg\-Haaren",
"494532", "Bargteheide",
"496086", "Grävenwiesbach",
"494171", "Winsen\ Luhe",
"495946", "Georgsdorf",
"4939996", "Törpin",
"493473", "Aschersleben\ Sachsen\-Anhalt",
"4937204", "Lichtenstein\ Sachsen",
"497394", "Schelklingen",
"494465", "Friedeburg\ Ostfriesland",
"494488", "Westerstede",
"492434", "Wegberg",
"492722", "Attendorn",
"497181", "Schorndorf\ Württemberg",
"496827", "Eppelborn",
"499723", "Röthlein",
"495228", "Vlotho\-Exter",
"492776", "Bad\ Endbach\-Hartenrod",
"496523", "Holsthum",
"498038", "Vogtareuth",
"493841", "Wismar",
"492686", "Weyerbusch",
"4936623", "Berga\ Elster",
"497247", "Linkenheim\-Hochstetten",
"4939247", "Güterglück",
"494463", "Wangerland",
"496234", "Mutterstadt",
"498841", "Murnau\ am\ Staffelsee",
"493475", "Lutherstadt\ Eisleben",
"49611", "Wiesbaden",
"496525", "Irrel",
"495277", "Höxter\-Fürstenau",
"499186", "Lauterhofen\ Oberpfalz",
"4933984", "Blumenthal\ bei\ Pritzwalk",
"499725", "Poppenhausen\ Unterfranken",
"494554", "Wahlstedt",
"494254", "Eystrup",
"498726", "Schönau\ Niederbayern",
"492357", "Herscheid\ Westfalen",
"497955", "Wallhausen\ Württemberg",
"498168", "Attenkirchen",
"494127", "Westerhorn",
"495873", "Eimke",
"493772", "Schneeberg\ Erzgebirge",
"498704", "Altdorf\-Pfettrach",
"4934498", "Rositz",
"498772", "Mallersdorf\-Pfaffenberg",
"495346", "Liebenburg",
"4938824", "Mallentin",
"493726", "Flöha",
"499978", "Schönthal\ Oberpfalz",
"4934977", "Quellendorf",
"497843", "Renchen",
"499422", "Bogen\ Niederbayern",
"499734", "Burkardroth",
"495329", "Schulenberg\ im\ Oberharz",
"497322", "Giengen\ an\ der\ Brenz",
"492423", "Langerwehe",
"496101", "Bad\ Vilbel",
"4938752", "Zierzow\ bei\ Ludwigslust",
"496534", "Mülheim\ Mosel",
"497376", "Langenenslingen",
"496223", "Neckargemünd",
"494762", "Kutenholz",
"494744", "Loxstedt",
"495441", "Diepholz",
"49481", "Heide\ Holstein",
"495528", "Gieboldehausen",
"495875", "Emmendorf",
"494178", "Radbruch",
"497953", "Blaufelden",
"497471", "Hechingen",
"498682", "Laufen\ Salzach",
"4939223", "Theessen",
"4936647", "Saalburg\ Thüringen",
"4934783", "Gerbstedt",
"499371", "Miltenberg",
"4938732", "Gallin\ bei\ Lübz",
"4939778", "Ferdinandshof\ bei\ Torgelow",
"4933731", "Trebbin",
"4936427", "Dornburg\ Saale",
"499097", "Marxheim",
"492425", "Nideggen\-Embken",
"4938461", "Bützow",
"4935841", "Grossschönau\ Sachsen",
"4935772", "Rietschen",
"498259", "Schiltberg",
"4939927", "Nossentiner\ Hütte",
"493682", "Zella\-Mehlis",
"499927", "Kirchberg\ Wald",
"497165", "Göppingen\-Hohenstaufen",
"4936484", "Knau\ bei\ Pössneck",
"4936692", "Bürgel",
"495221", "Herford",
"494232", "Langwedel\ Kreis\ Verden",
"498456", "Lenting",
"498031", "Rosenheim\ Oberbayern",
"496500", "Waldrach",
"496443", "Ehringshausen\ Dill",
"495105", "Barsinghausen",
"496552", "Olzheim",
"4936022", "Grossengottern",
"4939959", "Dargun",
"4936871", "Bad\ Colberg\-Heldburg",
"494293", "Ottersberg\-Fischerhude",
"4938206", "Graal\-Müritz\ Seeheilbad",
"4936742", "Uhlstädt",
"492245", "Much",
"494481", "Hatten\-Sandkrug",
"4936459", "Blankenhain\ Thüringen",
"492753", "Erndtebrück",
"496445", "Schöffengrund",
"495674", "Grebenstein",
"495602", "Hessisch\ Lichtenau",
"4939329", "Möringen",
"497163", "Ebersbach\ an\ der\ Fils",
"495066", "Sarstedt",
"496871", "Wadern",
"499279", "Mistelgau",
"49214", "Leverkusen",
"497662", "Vogtsburg\ im\ Kaiserstuhl",
"492755", "Bad\ Berleburg\-Schwarzenau",
"496637", "Feldatal",
"497024", "Wendlingen\ am\ Neckar",
"497644", "Kenzingen",
"492243", "Eitorf",
"499264", "Küps",
"494295", "Emtinghausen",
"499242", "Gössweinstein",
"495103", "Wennigsen\ Deister",
"495650", "Cornberg",
"4934741", "Frose",
"4935202", "Klingenberg\ Sachsen",
"492401", "Baesweiler",
"496123", "Eltville\ am\ Rhein",
"498283", "Neuburg\ an\ der\ Kammel",
"4937361", "Neuhausen\ Erzgebirge",
"497581", "Saulgau",
"4939208", "Loitsche",
"492865", "Raesfeld",
"497735", "Öhningen",
"493491", "Lutherstadt\ Wittenberg",
"496676", "Hohenroda\ Hessen",
"494834", "Büsum",
"4934691", "Könnern",
"496622", "Bebra",
"496042", "Büdingen\ Hessen",
"499954", "Simbach\ Niederbayern",
"492324", "Hattingen\ Ruhr",
"497733", "Engen\ Hegau",
"4935828", "Reichenbach\ OL",
"49971", "Bad\ Kissingen",
"4937349", "Scheibenberg",
"492863", "Velen",
"499844", "Obernzenn",
"494154", "Trittau",
"4937296", "Stollberg\ Erzgebirge",
"498268", "Tussenhausen",
"498285", "Burtenbach",
"49651", "Trier",
"496786", "Kempfeld",
"492306", "Lünen",
"4933080", "Marienthal\ Kreis\ Oberhavel",
"4939822", "Kratzeburg",
"492567", "Ahaus\-Alstätte",
"496201", "Weinheim\ Bergstr",
"495520", "Braunlage",
"4940", "Hamburg",
"4939754", "Löcknitz\ Vorpom",
"4969", "Frankfurt\ am\ Main",
"4934953", "Gräfenhainichen",
"492642", "Remagen",
"493902", "Diesdorf\ Altm",
"4934920", "Kropstädt",
"499643", "Auerbach\ in\ der\ Oberpfalz",
"493561", "Guben",
"492664", "Rennerod",
"498561", "Pfarrkirchen\ Niederbayern",
"492992", "Marsberg",
"497263", "Waibstadt",
"499179", "Freystadt",
"4935756", "Hosena",
"494447", "Vechta\-Langförden",
"492933", "Sundern\ Sauerland",
"496297", "Ravenstein\ Baden",
"499932", "Osterhofen",
"499708", "Bad\ Bocklet",
"493969", "Siedenbollentin",
"494195", "Hartenholm",
"499142", "Treuchtlingen",
"495203", "Werther\ Westfalen",
"4935362", "Schönewalde\ bei\ Herzberg",
"496508", "Hetzerath\ Mosel",
"494635", "Sörup",
"499164", "Langenfeld\ Mittelfranken",
"494852", "Brunsbüttel",
"494942", "Südbrookmerland",
"498407", "Grossmehring",
"494964", "Rhede\ Ems",
"4934606", "Teicha\ Sachsen\-Anhalt",
"497265", "Angelbachtal",
"4933981", "Putlitz",
"495536", "Holzminden\-Neuhaus",
"499645", "Eschenbach\ in\ der\ Oberpfalz",
"495121", "Hildesheim",
"4933846", "Dippmannsdorf",
"495658", "Wehretal",
"494132", "Amelinghausen",
"494633", "Satrup",
"495205", "Bielefeld\-Sennestadt",
"494193", "Henstedt\-Ulzburg",
"496344", "Schwegenheim",
"497337", "Nellingen\ Alb",
"492935", "Sundern\-Hachen",
"496362", "Alsenz",
"493629", "Stadtilm",
"498629", "Palling",
"495505", "Hardegsen",
"496152", "Gross\-Gerau",
"498026", "Hausham",
"4935032", "Langenhennersdorf",
"496653", "Burghaun",
"495236", "Blomberg\-Grossenmarpe",
"493996", "Teterow",
"492408", "Aachen\-Kornelimünster",
"492924", "Möhnesee",
"4934205", "Markranstädt",
"4938821", "Lüdersdorf",
"4939080", "Kalbe\ Milde",
"498072", "Haag\ in\ Oberbayern",
"4939038", "Henningen",
"4937320", "Mulda\ Sachsen",
"497565", "Aichstetten\ Kreis\ Ravensburg",
"494271", "Sulingen",
"4935875", "Obercunnersdorf\ bei\ Löbau",
"496893", "Saarbrücken\-Ensheim",
"4934347", "Oelzschau\ bei\ Borna",
"495503", "Nörten\-Hardenberg",
"4933734", "Felgentreu",
"4935844", "Oybin\ Kurort",
"499354", "Rieneck",
"495807", "Altenmedingen",
"4938464", "Bernitt",
"495382", "Bad\ Gandersheim",
"497454", "Sulz\ am\ Neckar",
"497389", "Heroldstatt",
"496597", "Jünkerath",
"4938294", "Neubukow",
"497563", "Kisslegg",
"494624", "Kropp",
"4939058", "Uthmöden",
"498261", "Mindelheim",
"496832", "Beckingen\-Reimsbach",
"4935052", "Kipsdorf\ Kurort",
"496655", "Neuhof\ Kreis\ Fulda",
"492737", "Netphen\-Deuz",
"4933208", "Fahrland",
"494606", "Wanderup",
"4938855", "Lübtheen",
"4936874", "Schönbrunn\ bei\ Hildburghaus",
"496134", "Mainz\-Kastel",
"496694", "Neukirchen\ Knüll",
"499701", "Sandberg\ Unterfranken",
"497147", "Sachsenheim\ Württemberg",
"492335", "Wetter\ Ruhr",
"497937", "Dörzbach",
"495084", "Hambühren",
"492053", "Velbert\-Neviges",
"496501", "Konz",
"493731", "Freiberg\ Sachsen",
"495177", "Edemissen\-Abbensen",
"494823", "Wilster",
"492267", "Wipperfürth",
"494364", "Dahme\ Kreis\ Ostholstein",
"49621", "Mannheim",
"499395", "Triefenstein",
"494342", "Preetz\ Kreis\ Plön",
"4936481", "Neustadt\ an\ der\ Orla",
"493585", "Löbau",
"494480", "Ovelgönne\-Strückhausen",
"498585", "Grainet",
"4936608", "Seelingstädt\ bei\ Gera",
"498731", "Dingolfing",
"494527", "Bosau",
"499286", "Oberkotzau",
"4933970", "Neustadt\ Dosse",
"4933368", "Hohensaaten",
"499332", "Marktbreit",
"495439", "Bersenbrück",
"49241", "Aachen",
"496467", "Hatzfeld\ Eder",
"497724", "St\ Georgen\ im\ Schwarzwald",
"497432", "Albstadt\-Tailfingen",
"492333", "Ennepetal",
"497706", "Oberbaldingen",
"498369", "Rückholz",
"496854", "Oberthal\ Saar",
"493302", "Hennigsdorf",
"498583", "Neureichenau",
"4936845", "Gehlberg",
"493583", "Zittau",
"498302", "Görisried",
"499393", "Rothenfels\ Unterfranken",
"498374", "Dietmannsried",
"495766", "Rehburg\-Loccum",
"494825", "Burg\ Dithmarschen",
"495651", "Eschwege",
"492392", "Werdohl",
"495128", "Hohenhameln",
"494255", "Martfeld",
"497954", "Kirchberg\ an\ der\ Jagst",
"495130", "Wedemark",
"496206", "Lampertheim",
"498705", "Altfraunhofen",
"496157", "Pfungstadt",
"4939347", "Kade",
"494743", "Langen\ bei\ Bremerhaven",
"4938484", "Ventschow",
"496224", "Sandhausen\ Baden",
"4938459", "Laage",
"499735", "Massbach",
"493391", "Neuruppin",
"4933872", "Hohennauen",
"496535", "Osann\-Monzel",
"4938871", "Mühlen\ Eichsen",
"494608", "Handewitt",
"4933741", "Niedergörsdorf",
"4936206", "Grossfahner",
"496781", "Idar\-Oberstein",
"492301", "Holzwickede",
"4935825", "Kodersdorf",
"494745", "Bad\ Bederkesa",
"498703", "Essenbach",
"495874", "Soltendieck",
"495802", "Wrestedt",
"496592", "Daun",
"494253", "Asendorf\ Kreis\ Diepholz",
"492406", "Herzogenrath",
"4933769", "Töpchin",
"495238", "Nieheim\-Himmighausen",
"493998", "Demmin",
"496533", "Morbach\ Hunsrück",
"4939205", "Langenweddingen",
"498028", "Fischbachau",
"495850", "Neetze",
"492732", "Kreuztal",
"492424", "Vettweiss",
"4939402", "Völpke",
"493496", "Köthen\ Anhalt",
"4933703", "Sperenberg",
"496837", "Wallerfangen",
"499733", "Münnerstadt",
"497586", "Herbertingen",
"49771", "Donaueschingen",
"497844", "Rheinau",
"4933055", "Kremmen",
"494189", "Undeloh",
"495149", "Wienhausen",
"497164", "Boll\ Kreis\ Göppingen",
"497142", "Bietigheim\-Bissingen",
"497708", "Geisingen\-Leipferdingen",
"497932", "Niederstetten\ Württemberg",
"49291", "Meschede",
"495939", "Sustrum",
"499180", "Pyrbaum",
"495673", "Immenhausen\ Hessen",
"492262", "Wiehl",
"495172", "Ilsede",
"499263", "Ludwigsstadt",
"492680", "Mündersbach",
"494347", "Flintbek",
"492244", "Königswinter\-Oberpleis",
"497023", "Weilheim\ an\ der\ Teck",
"495126", "Algermissen",
"497643", "Herbolzheim\ Breisgau",
"495768", "Petershagen\-Heimsen",
"495531", "Holzminden",
"4933920", "Walsleben\ bei\ Neuruppin",
"4939007", "Tangeln",
"494522", "Plön",
"495675", "Trendelburg",
"499337", "Gaukönigshofen",
"496444", "Bischoffen",
"4934385", "Mutzschen",
"496462", "Gladenbach",
"4939365", "Bellingen\ bei\ Stendal",
"492770", "Eschenburg",
"4938797", "Karstädt\ Kreis\ Prignitz",
"49461", "Flensburg",
"496409", "Biebertal",
"4936461", "Bad\ Sulza",
"492754", "Bad\ Laasphe\-Feudingen",
"497645", "Freiamt",
"4933933", "Lindow\ Mark",
"493307", "Zehdenick",
"497025", "Neuffen",
"499265", "Pressig",
"4933237", "Paulinenaue",
"499288", "Bad\ Steben",
"4933606", "Müllrose",
"494294", "Riede\ Kreis\ Verden",
"4936732", "Könitz",
"4938427", "Blowatz",
"4939392", "Rönnebeck\ Sachsen\-Anhalt",
"498266", "Kirchheim\ in\ Schwaben",
"4933205", "Michendorf",
"4938858", "Lassahn",
"49209", "Gelsenkirchen",
"499565", "Untersiemau",
"4939055", "Hörsingen",
"496765", "Gemünden\ Hunsrück",
"496788", "Sien",
"492308", "Unna\-Hemmerde",
"496047", "Altenstadt\ Hessen",
"496627", "Nentershausen\ Hessen",
"497034", "Ehningen",
"493991", "Waren\ Müritz",
"495231", "Detmold",
"496763", "Kirchberg\ Hunsrück",
"494222", "Ganderkesee",
"498021", "Waakirchen",
"498641", "Grassau\ Kreis\ Traunstein",
"4934208", "Löbnitz\ bei\ Delitzsch",
"499867", "Geslau",
"4939035", "Kuhfelde",
"493641", "Jena",
"499563", "Rödental",
"494276", "Borstel\ bei\ Sulingen",
"4939741", "Jatznick",
"492562", "Gronau\ Westfalen",
"4937381", "Penig",
"499454", "Aufhausen\ Oberpfalz",
"495482", "Tecklenburg",
"497354", "Erolzheim",
"496678", "Wildeck\-Hönebach",
"4935604", "Krieschow",
"4938306", "Samtens",
"492509", "Nottuln\-Appelhülsen",
"493907", "Gardelegen",
"4939933", "Vollrathsruhe",
"492647", "Kesseling",
"495656", "Waldkappel",
"496233", "Frankenthal\ Pfalz",
"495761", "Stolzenau",
"497395", "Ehingen\-Dächingen",
"4938391", "Altenkirchen\ Rügen",
"4936848", "Wernshausen",
"494464", "Wittmund\-Carolinensiel",
"4939606", "Glienke",
"494442", "Lohne\ Oldenburg",
"499495", "Breitenbrunn\ Oberpfalz",
"496292", "Seckach",
"492435", "Erkelenz\-Lövenich",
"494553", "Geschendorf",
"497052", "Bad\ Liebenzell",
"499937", "Oberpöring",
"4939323", "Schönhausen\ Elbe",
"495060", "Bodenburg",
"499147", "Nennslingen",
"494857", "Barlt",
"494479", "Molbergen\-Peheim",
"4933365", "Lüdersdorf\ Kreis\ Barnim",
"498402", "Münchsmünster",
"494947", "Aurich\-Ogenbargen",
"499493", "Beratzhausen",
"4936640", "Remptendorf",
"4936453", "Mellingen",
"497393", "Munderkingen",
"496235", "Schifferstadt",
"4936605", "Bad\ Köstritz",
"499281", "Hof\ Saale",
"494137", "Barendorf",
"4939953", "Schwinkendorf",
"4938726", "Spornitz",
"4934904", "Oranienbaum",
"496524", "Rodershausen",
"4939388", "Goldbeck\ Altm",
"498469", "Freystadt\-Burggriesbach",
"499724", "Stadtlauringen",
"496506", "Welschbillig",
"49231", "Dortmund",
"495339", "Gielde",
"494555", "Seedorf\ bei\ Bad\ Segeberg",
"498450", "Ingolstadt\-Zuchering",
"497332", "Lauterstein",
"492433", "Hückelhoven",
"495691", "Bad\ Arolsen",
"497453", "Altensteig\ Württemberg",
"492352", "Altena\ Westfalen",
"495131", "Garbsen",
"499353", "Karlstadt",
"494122", "Uetersen",
"495504", "Friedland\ Kreis\ Göttingen",
"4938874", "Lützow",
"495941", "Neuenhaus\ Dinkel",
"4933744", "Hohenseefeld",
"495572", "Bodenfelde",
"496081", "Usingen",
"494176", "Marschacht",
"496894", "St\ Ingbert",
"497579", "Schwenningen\ Baden",
"499427", "Leiblfing",
"4934927", "Globig\-Bleddin",
"497327", "Dischingen",
"492925", "Warstein\-Allagen",
"497564", "Bad\ Wurzach",
"494623", "Böklund",
"497542", "Tettnang",
"4937343", "Jöhstadt",
"4934223", "Dommitzsch",
"497971", "Gaildorf",
"4938481", "Witzin",
"494767", "Bremervörde\-Bevern",
"496670", "Ludwigsau\ Hessen",
"498166", "Allershausen\ Oberbayern",
"498728", "Geratskirchen",
"499355", "Frammersbach",
"497455", "Dornhan",
"498687", "Taching\-Tengling",
"499092", "Wemding",
"494625", "Jübek",
"495851", "Dahlenburg",
"499976", "Rötz",
"4939728", "Medow\ bei\ Anklam",
"4935722", "Lauta\ bei\ Hoyerswerda",
"492923", "Lippetal\-Herzfeld",
"496654", "Gersfeld\ Rhön",
"499922", "Zwiesel",
"4939268", "Egeln",
"4938845", "Kaarssen",
"4939977", "Jördenstorf",
"496135", "Bodenheim\ Rhein",
"496695", "Jesberg",
"497723", "Furtwangen\ im\ Schwarzwald",
"492334", "Hagen\-Hohenlimburg",
"494237", "Bendingbostel",
"495085", "Burgdorf\-Ehlershausen",
"495068", "Elze\ Leine",
"499181", "Neumarkt\ in\ der\ Oberpfalz",
"4937755", "Schönheide\ Erzgebirge",
"4936072", "Weissenborn\-Lüderode",
"496557", "Hallschlag",
"494365", "Heringsdorf\ Holstein",
"499394", "Esselbach",
"498373", "Altusried",
"492681", "Altenkirchen\ Westerwald",
"498846", "Uffing\ am\ Staffelsee",
"4939856", "Beenz\ bei\ Prenzlau",
"498584", "Breitenberg\ Niederbayern",
"496853", "Marpingen",
"495607", "Fuldatal",
"492054", "Essen\-Kettwig",
"4936464", "Wormstedt",
"495083", "Hohne\ bei\ Celle",
"497725", "Königsfeld\ im\ Schwarzwald",
"496693", "Neuental",
"498458", "Gaimersheim",
"496133", "Oppenheim",
"492771", "Dillenburg",
"497667", "Breisach\ am\ Rhein",
"496855", "Freisen",
"496192", "Hofheim\ am\ Taunus",
"494806", "Sarzbüttel",
"493375", "Königs\ Wusterhausen",
"498375", "Weitnau",
"4933087", "Bredereiche",
"494824", "Krempe",
"494363", "Lensahn",
"499376", "Collenberg",
"499547", "Zapfendorf",
"497476", "Bisingen",
"4939775", "Ahlbeck\ bei\ Torgelow",
"4933977", "Gumtow",
"492842", "Kamp\-Lintfort",
"496747", "Emmelshausen",
"494153", "Lauenburg\ Elbe",
"495429", "Melle\-Wellingholzhausen",
"499843", "Burgbernheim",
"497734", "Gailingen",
"492323", "Herne",
"497422", "Schramberg",
"492864", "Reken",
"495446", "Rehden",
"494835", "Albersdorf\ Holstein",
"495138", "Sehnde",
"495948", "Itterbeck",
"494289", "Kirchtimke",
"499955", "Mamming",
"4935793", "Elstra",
"4934462", "Laucha\ Unstrut",
"492325", "Wanne\-Eickel",
"496106", "Rodgau",
"499845", "Oberdachstetten",
"494892", "Schenefeld\ Mittelholstein",
"494155", "Büchen",
"498284", "Ziemetshausen",
"495858", "Hitzacker\-Wietzetze",
"498020", "Weyarn",
"498640", "Reit\ Im\ Winkl",
"497371", "Riedlingen\ Württemberg",
"4939482", "Gatersleben",
"496124", "Bad\ Schwalbach",
"4935601", "Peitz",
"499471", "Burglengenfeld",
"496257", "Seeheim\-Jugenheim",
"499953", "Pilsting",
"496063", "Bad\ König",
"494537", "Sülfeld\ Holstein",
"498721", "Eggenfelden",
"492952", "Rüthen",
"4934495", "Dobitschen",
"4934292", "Brandis\ bei\ Wurzen",
"493721", "Meinersdorf",
"494833", "Wesselburen",
"4937384", "Wechselburg",
"495341", "Salzgitter",
"4939744", "Rothenklempenow",
"494381", "Lütjenburg",
"4933836", "Butzow\ bei\ Brandenburg",
"492688", "Kroppach",
"494963", "Dörpen",
"4939087", "Jerchel\ Altmark",
"4937327", "Rechenberg\-Bienenmühle",
"4935026", "Dürrröhrsdorf\-Dittersbach",
"496343", "Bad\ Bergzabern",
"494194", "Sievershütten",
"4935696", "Briesnig",
"496876", "Weiskirchen\ Saar",
"494634", "Husby",
"4933964", "Fretzdorf",
"499188", "Postbauer\-Heng",
"499165", "Sugenheim",
"498639", "Neumarkt\-Sankt\ Veit",
"4934901", "Rosslau\ Elbe",
"497242", "Rheinstetten",
"494965", "Surwold",
"497264", "Bad\ Rappenau",
"492663", "Westerburg\ Westerwald",
"499280", "Selbitz\ Oberfranken",
"499644", "Pressath",
"499662", "Vilseck",
"494486", "Edewecht\-Friedrichsfehn",
"493973", "Pasewalk",
"499163", "Dachsbach",
"492162", "Viersen",
"495204", "Steinhagen\ Westfalen",
"495272", "Brakel\ Westfalen",
"4937602", "Kirchberg\ Sachsen",
"496345", "Albersweiler",
"498036", "Stephanskirchen\ Simssee",
"495226", "Bruchmühlen\ Westfalen",
"492778", "Siegbach",
"492934", "Sundern\-Altenhellefeld",
"498622", "Tacherting\-Peterskirchen",
"498042", "Lenggries",
"4939823", "Rechlin",
"496159", "Messel",
"497505", "Fronreute",
"4933671", "Lieberose",
"498064", "Au\ bei\ Bad\ Aibling",
"494241", "Bassum",
"492485", "Schleiden\-Dreiborn",
"4935241", "Lommatzsch",
"493622", "Waltershausen\ Thüringen",
"496283", "Hardheim\ Odenwald",
"4933454", "Wölsickendorf\/Wollenberg",
"495565", "Einbeck\-Wenzen",
"497236", "Keltern",
"494330", "Emkendorf",
"498123", "Moosinning",
"495454", "Hörstel\-Riesenbeck",
"494666", "Ladelund",
"499482", "Wörth\ an\ der\ Donau",
"494751", "Otterndorf",
"497807", "Neuried\ Ortenaukreis",
"497382", "Römerstein",
"497440", "Bad\ Rippoldsau",
"4939888", "Lychen",
"497503", "Wilhelmsdorf\ Württemberg",
"4935203", "Tharandt",
"492291", "Waldbröl",
"4937297", "Thum\ Sachsen",
"499340", "Königheim\-Brehmen",
"49851", "Passau",
"499231", "Marktredwitz",
"494187", "Holm\-Seppensen",
"4937467", "Klingenthal\ Sachsen",
"496396", "Hinterweidenthal",
"495563", "Kreiensen",
"4938224", "Gresenhorst",
"4933434", "Herzfelde\ bei\ Strausberg",
"49351", "Dresden",
"496268", "Hüffenhardt",
"496285", "Walldürn\-Altheim",
"492156", "Willich\-Anrath",
"492598", "Senden\-Ottmarsbocholt",
"494326", "Wankendorf",
"497084", "Schömberg\ bei\ Neuenbürg",
"497220", "Forbach\-Hundsbach",
"495937", "Geeste\-Gross\ Hesepe",
"495147", "Uetze\-Hänigsen",
"4936781", "Grossbreitenbach",
"492207", "Kürten\-Dürscheid",
"494372", "Westfehmarn",
"496561", "Bitburg",
"4989", "Munich",
"4934322", "Rosswein",
"499761", "Bad\ Königshofen\ im\ Grabfeld",
"499656", "Moosbach\ bei\ Vohenstrauss",
"495495", "Vörden\ Kreis\ Vechta",
"494349", "Dänischenhagen",
"498344", "Westendorf\ bei\ Kaufbeuren",
"495706", "Porta\ Westfalica",
"4933847", "Görzke",
"498362", "Füssen",
"494421", "Wilhelmshaven",
"493362", "Erkner",
"499339", "Ippesheim",
"495724", "Obernkirchen",
"495432", "Löningen",
"493344", "Bad\ Freienwalde",
"4934607", "Wettin",
"497651", "Titisee\-Neustadt",
"492836", "Wachtendonk",
"497128", "Sonnenbühl",
"495493", "Neuenkirchen\ Kreis\ Vechta",
"4935363", "Fermerswalde",
"495281", "Bad\ Pyrmont",
"496407", "Rabenau\ Hessen",
"496004", "Lich\-Eberstadt",
"496646", "Grebenau",
"496026", "Grossostheim",
"492630", "Mülheim\-Kärlich",
"496629", "Schenklengsfeld",
"496049", "Kefenrod",
"498152", "Herrsching\ am\ Ammersee",
"4935020", "Struppen",
"494248", "Bassum\-Neubruchhausen",
"4935053", "Glashütte\ Sachsen",
"4934635", "Bad\ Lauchstädt",
"4934441", "Hohenmölsen",
"492461", "Jülich",
"4933830", "Ziesar",
"494140", "Estorf\ Kreis\ Stade",
"499238", "Röslau",
"4939454", "Elbingerode\ Harz",
"4934299", "Gaschwitz",
"499869", "Wettringen\ Mittelfranken",
"4934346", "Narsdorf",
"496261", "Mosbach\ Baden",
"495733", "Vlotho",
"492507", "Havixbeck",
"494758", "Nordleda",
"4933638", "Rüdersdorf\ bei\ Berlin",
"492366", "Herten\ Westfalen",
"499874", "Neuendettelsau",
"4939489", "Strassberg\ Harz",
"498208", "Eurasburg\ bei\ Augsburg",
"499802", "Ansbach\-Katterbach",
"4935033", "Rosenthal\ Sächsische\ Schweiz",
"497520", "Bodnegg",
"492803", "Wesel\-Büderich",
"499104", "Emskirchen",
"4938371", "Karlshagen",
"496585", "Ralingen",
"496568", "Wolsfeld",
"499172", "Georgensgmünd",
"496731", "Alzey",
"495263", "Barntrup",
"4935325", "Rückersdorf\ bei\ Finsterwalde",
"492173", "Langenfeld\ Rheinland",
"499126", "Eckental",
"493909", "Klötze\ Altmark",
"499531", "Ebern",
"49821", "Augsburg",
"4936704", "Steinheid",
"499149", "Weissenburg\-Suffersheim",
"492591", "Lüdinghausen",
"492626", "Selters\ Westferwald",
"494477", "Lastrup\-Hemmelte",
"497203", "Walzbachtal",
"494859", "Windbergen",
"4935456", "Terpt",
"498501", "Thyrnau",
"492604", "Nassau\ Lahn",
"492672", "Treis\-Karden",
"493501", "Pirna",
"493944", "Blankenburg\ Harz",
"498134", "Odelzhausen",
"4935935", "Kleinwelka",
"493962", "Penzlin\ bei\ Waren",
"499673", "Tiefenbach\ Oberpfalz",
"496302", "Winnweiler",
"497121", "Reutlingen",
"496374", "Weilerbach",
"496887", "Schmelz\ Saar",
"494139", "Hohnstorf\ Elbe",
"492175", "Leichlingen\ Rheinland",
"4937609", "Wolkenburg\ Mulde",
"495265", "Dörentrup",
"496583", "Palzem",
"495337", "Kissenbrück",
"499675", "Altendorf\ am\ Nabburg",
"494926", "Krummhörn\-Greetsiel",
"4935955", "Pulsnitz",
"4935436", "Laasow\ bei\ Calau",
"494972", "Langeoog",
"4936258", "Friemar",
"494541", "Ratzeburg",
"498467", "Kinding",
"4938452", "Lalendorf",
"4933451", "Heckelberg",
"499446", "Altmannstein",
"4933926", "Herzberg\ Mark",
"494684", "Langeness\ Hallig",
"497577", "Veringenstadt",
"494240", "Syke\-Heiligenfelde",
"497346", "Illerkirchberg",
"496161", "Brensbach",
"499948", "Eschlkam",
"495955", "Esterwegen",
"495376", "Wesendorf\ Kreis\ Gifhorn",
"498742", "Velden\ Vils",
"4933674", "Trebatsch",
"498764", "Mauern\ Kreis\ Freising",
"494331", "Rendsburg",
"492556", "Metelen",
"4935244", "Krögis",
"499429", "Rain\ Niederbayern",
"493764", "Meerane",
"495322", "Bad\ Harzburg",
"4933336", "Passow\ Kreis\ Uckermark",
"495843", "Wustrow\ Wendland",
"497329", "Steinheim\ am\ Albuch",
"492638", "Waldbreitbach",
"4935472", "Schlepzig",
"495953", "Börger",
"498086", "Buchbach\ Oberbayern",
"4933762", "Zeuthen",
"492984", "Hallenberg",
"4938221", "Marlow",
"4939409", "Eilsleben",
"4936963", "Dorndorf\ Rhön",
"497528", "Neukirch\ bei\ Tettnang",
"494769", "Bremervörde\-Iselersheim",
"497441", "Freudenstadt",
"492821", "Kleve\ Niederrhein",
"499341", "Tauberbischofsheim",
"494148", "Drochtersen\-Assel",
"49365", "Gera",
"495845", "Bergen\ Dumme",
"498252", "Schrobenhausen",
"4939997", "Jarmen",
"4939293", "Dreileben",
"494702", "Sandstedt",
"494938", "Hagermarsch",
"495471", "Bohmte",
"494774", "Hechthausen",
"494239", "Dörverden\-Westen",
"4936200", "Elxleben\ bei\ Arnstadt",
"497221", "Baden\-Baden",
"493523", "Coswig\ bei\ Dresden",
"492275", "Kerpen\-Buir",
"494885", "Bergenhusen",
"4936622", "Triebes",
"495165", "Rethem\ Aller",
"496473", "Leun",
"496559", "Leidenborn",
"4936784", "Stützerbach",
"497066", "Bad\ Rappenau\-Bonfeld",
"495163", "Fallingbostel\-Dorfmark",
"494883", "Süderstapel",
"492273", "Kerpen\-Horrem",
"499204", "Plankenfels",
"499272", "Fichtelberg",
"493525", "Riesa",
"49811", "Hallbergmoos",
"4939246", "Lindau\ Anh",
"495609", "Ahnatal",
"497674", "Todtmoos",
"4936739", "Rottenbach",
"496358", "Kriegsfeld",
"4939399", "Kleinau",
"496841", "Homburg\ Saar",
"497669", "St\ Märgen",
"495644", "Willebadessen\-Peckelsheim",
"495024", "Rohrsen\ Kreis\ Nienburg\ Weser",
"496475", "Weilmünster\-Wolfenhausen",
"495662", "Felsberg\ Hessen",
"498234", "Bobingen",
"495427", "Melle\-Buer",
"4936335", "Grosswechsungen",
"498534", "Tettenweis",
"499549", "Lisberg",
"492191", "Remscheid",
"4934444", "Lützen",
"494338", "Alt\ Duvenstedt",
"492631", "Neuwied",
"496704", "Langenlonsheim",
"499526", "Riedbach",
"4939425", "Dingelstedt\ am\ Huy",
"492384", "Welver",
"494287", "Heeslingen\-Boitzen",
"496772", "Nastätten",
"495035", "Gross\ Munzel",
"4939600", "Zwiedorf",
"4935773", "Schleife",
"499131", "Erlangen",
"498225", "Jettingen\-Scheppach",
"495353", "Königslutter\ am\ Elm",
"4936925", "Marksuhl",
"499941", "Kötzting",
"4934976", "Gröbzig",
"4933478", "Gross\ Neuendorf",
"499504", "Stadelhofen",
"496726", "Lorch\ Rheingau",
"4938733", "Karbow\-Vietlübbe",
"496185", "Hammersbach\ Hessen",
"499572", "Burgkunstadt",
"4934782", "Mansfeld\ Südharz",
"4939222", "Möser",
"492573", "Nordwalde",
"494141", "Stade",
"499851", "Dinkelsbühl",
"495976", "Salzbergen",
"496682", "Tann\ Rhön",
"495922", "Bad\ Bentheim",
"494931", "Norden",
"4938720", "Grebbin",
"492575", "Greven\-Reckenfeld",
"497946", "Bretzfeld",
"4939926", "Grabowhöfe",
"496183", "Erlensee",
"4938753", "Wöbbelin",
"4939451", "Wasserleben",
"497448", "Seewald",
"498223", "Ichenhausen",
"495355", "Frellstedt",
"4936646", "Tanna\ bei\ Schleiz",
"499348", "Werbach\-Gamburg",
"497136", "Bad\ Friedrichshall",
"4936426", "Ottendorf\ bei\ Stadtroda",
"495033", "Wunstorf\-Grossenheidorn",
"492828", "Emmerich\-Elten",
"494539", "Westerau",
"4937438", "Bad\ Brambach",
"498552", "Grafenau\ Niederbayern",
"4938374", "Lassan\ bei\ Wolgast",
"492590", "Dülmen\-Buldern",
"496456", "Haina\ Kloster",
"496031", "Friedberg\ Hessen",
"494405", "Edewecht",
"497228", "Forbach",
"498443", "Hohenwart\ Paar",
"493443", "Weissenfels\ Sachsen\-Anhalt",
"4938207", "Stäbelow",
"499085", "Alerheim",
"495181", "Alfeld\ Leine",
"4936701", "Lichte",
"494861", "Tönning",
"4938300", "Insel\ Hiddensee",
"492256", "Mechernich\-Satzvey",
"496848", "Homburg\-Einöd",
"4936693", "Crossen\ an\ der\ Elster",
"494796", "Teufelsmoor",
"498637", "Lohkirchen",
"4935389", "Holzdorf\ Elster",
"495247", "Harsewinkel",
"499607", "Luhe\-Wildenau",
"499083", "Möttingen",
"493445", "Naumburg\ Saale",
"498445", "Gerolsbach",
"497277", "Wörth\-Büchelberg",
"494403", "Bad\ Zwischenahn",
"493871", "Parchim",
"4936743", "Teichel",
"496351", "Eisenberg\ Pfalz",
"4936023", "Horsmar",
"494431", "Wildeshausen",
"495978", "Hörstel\-Dreierwalde",
"495734", "Bergkirchen\ Westfalen",
"495422", "Melle",
"497429", "Egesheim",
"495476", "Ostercappeln\-Venne",
"4936371", "Schlossvippach",
"492804", "Xanten\-Marienbaum",
"492872", "Rhede\ Westfalen",
"494282", "Sittensen",
"498081", "Dorfen\ Stadt",
"4935209", "Mohorn",
"499873", "Abenberg\-Wassermungenau",
"497948", "Öhringen\-Ohrnberg",
"4935723", "Bernsdorf\ OL",
"492826", "Kranenburg\ Niederrhein",
"497138", "Schwaigern",
"499346", "Grünsfeld",
"4934926", "Pretzsch\ Elbe",
"4935263", "Gröditz\ bei\ Riesa",
"497446", "Lossburg",
"498654", "Freilassing",
"495371", "Gifhorn",
"494336", "Owschlag",
"492551", "Steinfurt\-Burgsteinfurt",
"4936944", "Rentwertshausen",
"496003", "Rosbach\ von\ der\ Höhe",
"4934222", "Arzberg\ bei\ Torgau",
"4937342", "Cranzahl",
"499528", "Donnersdorf",
"499441", "Kelheim",
"4939976", "Gross\ Bützin",
"499875", "Wolframs\-Eschenbach",
"4934600", "Ostrau\ Saalkreis",
"498670", "Reischach\ Kreis\ Altötting",
"496166", "Fischbachtal",
"4939829", "Blankenförde",
"4934425", "Droyssig",
"496728", "Ober\-Hilbersheim",
"499105", "Grosshabersdorf",
"496584", "Wellen\ Mosel",
"4935974", "Hinterhermsdorf",
"495752", "Auetal\-Hattendorf",
"498557", "Mauth",
"496373", "Schönenberg\-Kübelberg",
"493695", "Bad\ Salzungen",
"4939857", "Drense",
"4938324", "Velgast",
"494903", "Wymeer",
"499221", "Kulmbach",
"492605", "Löf",
"498135", "Sulzemoos",
"4935341", "Bad\ Liebenwerda",
"496375", "Wallhalben",
"493632", "Sondershausen",
"492174", "Burscheid\ Rheinland",
"497249", "Stutensee",
"495264", "Kalletal",
"492102", "Ratingen",
"495242", "Rheda\-Wiedenbrück",
"498192", "Schondorf\ am\ Ammersee",
"499103", "Cadolzburg",
"499674", "Schönsee",
"497226", "Bühl\-Sand",
"4933086", "Grieben\ Kreis\ Oberhavel",
"499602", "Neustadt\ an\ der\ Waldnaab",
"494320", "Heidmühlen",
"496458", "Rosenthal\ Hessen",
"498133", "Haimhausen\ Oberbayern",
"493943", "Wernigerode",
"492603", "Bad\ Ems",
"492150", "Meerbusch\-Lank",
"497204", "Malsch\-Völkersbach",
"497272", "Rülzheim",
"493693", "Meiningen",
"4933976", "Wutike",
"492360", "Haltern\-Lippramsdorf",
"4933094", "Löwenberg",
"4938781", "Mellen",
"497941", "Öhringen",
"497504", "Horgenzell",
"498065", "Tuntenhausen\-Schönau",
"4939483", "Ballenstedt",
"497572", "Mengen\ Württemberg",
"492484", "Mechernich\-Eiserfey",
"497131", "Heilbronn\ Neckar",
"492359", "Kierspe",
"4934463", "Bad\ Kösen",
"494129", "Haseldorf",
"495453", "Recke",
"499856", "Dürrwangen",
"495542", "Witzenhausen",
"495971", "Rheine",
"4934293", "Naunhof\ bei\ Grimma",
"495564", "Dassel",
"494146", "Stade\-Bützfleth",
"495327", "Bad\ Grund\ Harz",
"494936", "Grossheide",
"495455", "Tecklenburg\-Brochterbeck",
"497348", "Beimerstetten",
"499448", "Hausen\ Niederbayern",
"4933475", "Letschin",
"499521", "Hassfurt",
"4936928", "Neuenhof\ Thüringen",
"498063", "Feldkirchen\-Westerham",
"496721", "Bingen\ am\ Rhein",
"499946", "Hohenwarth\ bei\ Kötzing",
"4939428", "Pabstorf",
"4935792", "Ossling",
"498124", "Forstern\ Oberbayern",
"499929", "Ruhmannsfelden",
"495378", "Sassenburg\-Platendorf",
"498257", "Inchenhofen",
"497851", "Kehl",
"492636", "Burgbrohl",
"498106", "Vaterstetten",
"492196", "Wermelskirchen",
"499099", "Kaisheim",
"4936338", "Bleicherode",
"496284", "Mudau",
"492558", "Horstmar",
"496020", "Heigenbrücken",
"494707", "Langen\-Neuenwalde",
"495723", "Bad\ Nenndorf",
"4939086", "Jävenitz",
"494920", "Wirdum",
"4937326", "Frauenstein\ Sachsen",
"497085", "Enzklösterle",
"4935027", "Weesenstein",
"498822", "Oberammergau",
"4933837", "Brielow",
"499228", "Thurnau",
"496356", "Carlsberg\ Pfalz",
"494305", "Westensee",
"493876", "Perleberg",
"498343", "Aitrang",
"4935697", "Bagenz",
"492251", "Euskirchen",
"4937603", "Wildenfels",
"495494", "Holdorf\ Niedersachsen",
"494791", "Osterholz\-Scharmbeck",
"498345", "Stöttwang",
"496036", "Wölfersheim",
"494303", "Schlesen",
"499277", "Warmensteinach",
"492620", "Neuhäusel\ Westerwald",
"496451", "Frankenberg\ Eder",
"497083", "Bad\ Herrenalb",
"4936085", "Reinholterode",
"495186", "Salzhemmendorf\-Wallensen",
"495725", "Lindhorst\ bei\ Stadthagen",
"4937421", "Oelsnitz\ Vogtland",
"492741", "Betzdorf",
"4936764", "Neuhaus\-Schierschnitz",
"496639", "Ottrau",
"4937435", "Reuth\ bei\ Plauen",
"499120", "Leinburg",
"4939346", "Tucheim",
"498535", "Haarbach",
"496391", "Dahn",
"498781", "Rottenburg\ an\ der\ Laaber",
"499236", "Nagel",
"493535", "Herzberg\ Elster",
"492368", "Oer\-Erkenschwick",
"492385", "Hamm\-Rhynern",
"4936207", "Plaue\ Thüringen",
"498157", "Feldafing",
"495034", "Neustadt\-Hagen",
"4933702", "Wünsdorf",
"498224", "Offingen\ Donau",
"4939885", "Jakobshagen",
"4939403", "Gröningen\ Sachsen\-Anhalt",
"4936969", "Merkers",
"494756", "Odisheim",
"494661", "Niebüll",
"499505", "Litzendorf",
"4936374", "Weissensee",
"492296", "Reichshof\-Brüchermühle",
"496184", "Langenselbold",
"4934671", "Bad\ Frankenhausen\ Kyffhäuser",
"498206", "Egling\ an\ der\ Paar",
"493533", "Elsterwerda",
"497231", "Pforzheim",
"498533", "Rotthalmünster",
"496648", "Bad\ Salzschlirf",
"496028", "Sulzbach\ am\ Main",
"492574", "Saerbeck",
"497340", "Neenstetten",
"494246", "Twistringen\-Heiligenloh",
"492502", "Nottuln",
"493671", "Saalfeld\ Saale",
"492961", "Brilon",
"4933873", "Grosswudicke",
"498592", "Wegscheid\ Niederbayern",
"499503", "Oberhaid\ Oberfranken",
"493592", "Kirschau",
"495354", "Jerxheim",
"499382", "Gerolzhofen",
"498671", "Altötting",
"492383", "Bönen",
"497482", "Horb\-Dettingen",
"496703", "Wöllstein\ Rheinhessen",
"4936941", "Wasungen",
"499177", "Heideck",
"4938321", "Martensdorf\ bei\ Stralsund",
"492831", "Geldern",
"497656", "Schluchsee",
"497761", "Bad\ Säckingen",
"495286", "Ottenstein\ Niedersachsen",
"4939393", "Werben\ Elbe",
"4936733", "Kaulsdorf",
"494404", "Elsfleth",
"494928", "Ihlow\-Riepe",
"4939006", "Miesterhorst",
"494472", "Lastrup",
"4935971", "Sebnitz",
"4933932", "Fehrbellin",
"495052", "Hermannsburg",
"492677", "Lutzerath",
"499084", "Bissingen\ Schwaben",
"499220", "Kasendorf\-Azendorf",
"494426", "Wangerland\-Horumersiel",
"493967", "Oertzenhof\ bei\ Strasburg",
"496307", "Schopp",
"496566", "Körperich",
"4938796", "Viesecke",
"4938355", "Züssow",
"499766", "Grosswenkheim",
"499651", "Vohenstrauss",
"499128", "Feucht",
"494321", "Neumünster",
"499439", "Neunburg\-Kemnath",
"493462", "Bad\ Dürrenberg",
"495332", "Schöppenstedt",
"4938426", "Neuburg\-Steinhausen",
"4933607", "Briesen\ Mark",
"492151", "Krefeld",
"492628", "Rhens",
"498444", "Schweitenkirchen",
"494977", "Blomberg\ Ostfriesland",
"498462", "Berching",
"492361", "Recklinghausen",
"494668", "Klanxbüll",
"4934658", "Hayn\ Harz",
"497940", "Künzelsau",
"492983", "Winterberg\-Siedlinghausen",
"4938759", "Tewswoos",
"497130", "Löwenstein\ Württemberg",
"495954", "Lorup",
"4933635", "Arensdorf\ Kreis\ Oder\-Spree",
"494773", "Lamstedt",
"496398", "Vorderweidenthal",
"4935895", "Klitten",
"4938784", "Kleinow\ Kreis\ Prignitz",
"498765", "Bruckberg\ Niederbayern",
"496266", "Hassmersheim",
"493765", "Reichenbach\ Vogtland",
"4933655", "Grunow\ Kreis\ Oder\-Spree",
"496599", "Weidenbach\ bei\ Gerolstein",
"497387", "Hohenstein\ Württemberg",
"497802", "Oberkirch\ Baden",
"492985", "Winterberg\-Niedersfeld",
"494683", "Oldsum",
"4934638", "Zöschen",
"498678", "Marktl",
"49571", "Minden\ Westfalen",
"492739", "Wilnsdorf",
"495586", "Wieda",
"4938307", "Poseritz",
"495844", "Clenze",
"495862", "Hitzacker\ Elbe",
"493763", "Glauchau",
"494182", "Tostedt",
"496021", "Aschaffenburg",
"496641", "Lauterbach\ Hessen",
"494775", "Grossenwörden",
"497939", "Schrozberg\-Spielbach",
"4936029", "Menteroda",
"4939952", "Grammentin",
"4939607", "Kotelow",
"497673", "Schönau\ im\ Schwarzwald",
"495932", "Haren\ Ems",
"4936255", "Goldbach\ bei\ Gotha",
"494921", "Emden\ Stadt",
"498292", "Dinkelscherben",
"495142", "Eschede",
"4936452", "Berlstedt",
"499203", "Neudrossenfeld",
"492274", "Elsdorf\ Rheinland",
"494884", "Schwabstedt",
"492202", "Bergisch\ Gladbach",
"494546", "Mustin\ Lauenburg",
"495164", "Hodenhagen",
"498233", "Kissing",
"497531", "Konstanz",
"4935383", "Elster\ Elbe",
"497126", "Burladingen\-Melchingen",
"495643", "Borgentreich",
"495023", "Liebenau\ Kreis\ Nieburg\ Weser",
"494529", "Süsel\-Bujendorf",
"492838", "Sonsbeck",
"492269", "Kierspe\-Rönsahl",
"497172", "Lorch\ Württemberg",
"4935938", "Grosspostwitz\ OL",
"498506", "Bad\ Höhenstadt",
"494328", "Rickling",
"492621", "Lahnstein",
"498367", "Rosshaupten\ Forggensee",
"492596", "Nordkirchen",
"492041", "Bottrop",
"499205", "Vorbach",
"4938727", "Mestlin",
"4933393", "Gross\ Schönebeck\ Kreis\ Barnim",
"492158", "Grefrath\ bei\ Krefeld",
"495437", "Menslage",
"4936761", "Heubisch",
"497675", "Bernau\ Baden",
"4939932", "Malchow\ bei\ Waren",
"496736", "Bechenheim",
"4939322", "Tangermünde",
"496402", "Hungen",
"499536", "Kirchlauter",
"496474", "Villmar\-Aumenau",
"49385", "Schwerin",
"495025", "Estorf\ Weser",
"495645", "Borgentreich\-Borgholz",
"499658", "Georgenberg",
"497934", "Weikersheim",
"494235", "Langwedel\-Etelsen",
"495603", "Gudensberg",
"4938302", "Sagard",
"4936844", "Rohr\ Thüringen",
"497162", "Süssen",
"496697", "Willingshausen",
"497144", "Marbach\ am\ Neckar",
"493328", "Teltow",
"49202", "Wuppertal",
"497663", "Eichstetten",
"494524", "Scharbeutz\-Pönitz",
"4936649", "Gefell\ bei\ Schleiz",
"492264", "Marienheide",
"495102", "Laatzen",
"496555", "Bleialf",
"494367", "Grossenbrode",
"4939929", "Jabel\ bei\ Waren",
"499243", "Pottenstein",
"495174", "Lahstedt",
"492242", "Hennef\ Sieg",
"498328", "Balderschwang",
"494506", "Stockelsdorf\-Krumbeck",
"493529", "Heidenau\ Sachsen",
"496442", "Braunfels",
"495605", "Kaufungen\ Hessen",
"497727", "Vöhrenbach",
"494233", "Blender",
"496464", "Angelburg",
"498377", "Unterthingau",
"495258", "Salzkotten",
"498546", "Windorf\-Otterskirchen",
"4939384", "Arendsee\ Altmark",
"498091", "Kirchseeon",
"499245", "Obertrubach",
"494292", "Ritterhude",
"4934979", "Wulfen\ Sachsen\-Anhalt",
"496553", "Schönecken",
"493921", "Burg\ bei\ Magdeburg",
"496857", "Namborn",
"497665", "March\ Breisgau",
"496479", "Waldbrunn\ Westerwald",
"4934364", "Wermsdorf",
"492752", "Bad\ Laasphe",
"4936875", "Straufhain\-Streufdorf",
"493377", "Zossen\ Brandenburg",
"493546", "Lübben\ Spreewald",
"4935386", "Prettin",
"4939327", "Klietz",
"4938854", "Redefin",
"494763", "Gnarrenburg",
"496222", "Wiesloch",
"497952", "Gerabronn",
"496276", "Hesseneck",
"4938295", "Satow\ bei\ Bad\ Doberan",
"4938722", "Raduhn",
"498683", "Tittmoning",
"492371", "Iserlohn",
"493683", "Schmalkalden",
"492927", "Neuengeseke",
"497325", "Sontheim\ an\ der\ Brenz",
"495551", "Northeim",
"493773", "Johanngeorgenstadt",
"495872", "Stoetze",
"4935874", "Bernstadt\ an\ der\ Eigen",
"499357", "Gräfendorf\ Bayern",
"495804", "Rätzlingen\ Kreis\ Uelzen",
"496594", "Birresborn",
"4934204", "Schkeuditz",
"497457", "Rottenburg\-Ergenzingen",
"494765", "Ebersdorf\ bei\ Bremervörde",
"495826", "Suderburg",
"498773", "Neufahrn\ in\ Niederbayern",
"492734", "Freudenberg\ Westfalen",
"497323", "Gerstetten",
"492422", "Kreuzau",
"495849", "Waddeweitz",
"4933396", "Klosterfelde",
"499423", "Geiselhöring",
"493685", "Hildburghausen",
"4939957", "Gielow",
"497842", "Kappelrodeck",
"4939602", "Kleeth",
"498685", "Kirchanschöring",
"4935608", "Gross\ Ossnig",
"494627", "Dörpstedt",
"493321", "Nauen\ Brandenburg",
"494462", "Wittmund",
"4939406", "Harbke",
"494444", "Goldenstedt",
"495741", "Lübbecke",
"49661", "Fulda",
"492667", "Stein\-Neukirch",
"498321", "Sonthofen",
"4939343", "Jerichow",
"497771", "Stockach",
"499167", "Oberscheinfeld",
"494409", "Westerstede\-Ocholt",
"492725", "Lennestadt\-Oedingen",
"496294", "Krautheim\ Jagst",
"499089", "Bissingen\-Unterringingen",
"497054", "Wildberg\ Württemberg",
"498426", "Walting\ Kreis\ Eichstätt",
"495251", "Paderborn",
"493928", "Schönebeck\ Elbe",
"4936202", "Neudietendorf",
"4933876", "Buschow",
"4936653", "Lehesten\ Thüringer\ Wald",
"498404", "Oberdolling",
"497681", "Waldkirch\ Breisgau",
"494967", "Rhauderfehn\-Burlage",
"4933929", "Gühlen\-Glienicke",
"499722", "Werneck",
"499434", "Bodenwöhr",
"496347", "Hochstadt\ Pfalz",
"492723", "Kirchhundem",
"497334", "Deggingen",
"499776", "Mellrichstadt",
"496522", "Mettendorf",
"4933760", "Münchehofe\ Kreis\ Dahme\-Spreewald",
"4936736", "Arnsgereuth",
"4933602", "Alt\ Zeschdorf",
"496745", "Gondershausen",
"4939396", "Neukirchen\ Altmark",
"494671", "Bredstedt",
"492378", "Fröndenberg\-Langschede",
"4939003", "Jübar",
"499545", "Buttenheim",
"4934771", "Querfurt",
"495636", "Lichtenfels\-Goddelsheim",
"496253", "Fürth\ Odenwald",
"4938488", "Demen",
"495196", "Wietzendorf",
"498246", "Waal",
"494533", "Reinfeld\ Holstein",
"49201", "Essen",
"492455", "Waldfeucht",
"497032", "Herrenberg",
"494837", "Neuenkirchen\ Dithmarschen",
"492971", "Schmallenberg\-Dorlar",
"4933233", "Ketzin",
"497300", "Roggenburg",
"494206", "Stuhr\-Heiligenrode",
"4938450", "Tarnow\ bei\ Bützow",
"492542", "Gescher",
"496255", "Lindenfels",
"4939721", "Liepen\ bei\ Anklam",
"492564", "Vreden",
"4938423", "Bad\ Kleinen",
"499543", "Hirschaid",
"493661", "Greiz",
"499847", "Ergersheim",
"498756", "Nandlstadt",
"498661", "Grabenstätt\ Chiemsee",
"492327", "Bochum\-Wattenscheid",
"494224", "Gross\ Ippener",
"496743", "Bacharach",
"4938793", "Dergenthin",
"499452", "Langquaid",
"495484", "Lienen\-Kattenvenne",
"497352", "Ochsenhausen",
"492453", "Heinsberg\-Randerath",
"494535", "Nahe",
"49941", "Regensburg",
"497433", "Balingen",
"492332", "Gevelsberg",
"49731", "Ulm\ Donau",
"4935797", "Schwepnitz",
"4934296", "Groitzsch\ bei\ Pegau",
"499333", "Sommerhausen",
"495151", "Hameln",
"496486", "Katzenelnbogen",
"493303", "Birkenwerder",
"498582", "Röhrnbach",
"4933973", "Zernitz\ bei\ Neustadt\ Dosse",
"4936841", "Schleusingen",
"492393", "Sundern\-Allendorf",
"493866", "Cambs",
"4934466", "Janisroda",
"4933968", "Meyenburg\ Kreis\ Prignitz",
"499392", "Faulbach\ Unterfranken",
"498303", "Waltenhofen",
"496381", "Kusel",
"4934361", "Dahlen\ Sachsen",
"499335", "Aub\ Kreis\ Würzburg",
"492052", "Velbert\-Langenberg",
"495677", "Calden\-Westuffeln",
"497435", "Albstadt\-Laufen",
"499267", "Nordhalben",
"494343", "Laboe",
"494822", "Kellinghusen",
"495831", "Wittingen",
"492395", "Finnentrop\-Rönkhausen",
"496634", "Gemünden\ Felda",
"494876", "Reher\ Holstein",
"495502", "Dransfeld",
"496155", "Griesheim\ Hessen",
"498707", "Adlkofen",
"495574", "Oberweser",
"4937606", "Lengenfeld\ Vogtland",
"495961", "Haselünne",
"494106", "Quickborn\ Kreis\ Pinneberg",
"494257", "Schweringen",
"492354", "Meinerzhagen",
"495383", "Lutter\ am\ Barenberge",
"494124", "Glückstadt",
"4938851", "Zarrentin",
"498075", "Amerang",
"497562", "Isny\ im\ Allgäu",
"4935439", "Zinnitz",
"497544", "Markdorf",
"4934243", "Bad\ Düben",
"4939083", "Messdorf",
"4937323", "Lichtenberg\ Erzgebirge",
"499737", "Wartmannsroth",
"496833", "Rehlingen\-Siersburg",
"495368", "Parsau",
"4935692", "Kerkwitz",
"498146", "Moorenweis",
"494747", "Beverstedt",
"496835", "Beckingen",
"497308", "Nersingen",
"496652", "Hünfeld",
"4935022", "Bad\ Schandau",
"499408", "Altenthann",
"499924", "Bodenmais",
"4938825", "Klütz",
"498073", "Gars\ am\ Inn",
"499906", "Mariaposching",
"499094", "Tagmersheim",
"4933832", "Rogäsen",
"4939748", "Viereck",
"497071", "Tübingen",
"496589", "Kell\ am\ See",
"4937347", "Bärenstein\ Kreis\ Annaberg",
"494943", "Grossefehn",
"4935726", "Gross\ Särchen",
"499497", "Seubersdorf\ in\ der\ Oberpfalz",
"494133", "Wittorf\ Kreis\ Lüneburg",
"4934923", "Cobbelsdorf",
"492645", "Vettelschoss",
"497754", "Görwihl",
"4935266", "Heyda\ bei\ Riesa",
"498320", "Missen\-Wilhams",
"496806", "Heusweiler",
"499145", "Solnhofen",
"494192", "Bad\ Bramstedt",
"495158", "Hemeringen",
"494632", "Steinbergkirche",
"495621", "Bad\ Wildungen",
"494855", "Eddelak",
"495041", "Springe\ Deister",
"496363", "Niederkirchen",
"496824", "Ottweiler",
"499935", "Stephansposching",
"495250", "Delbrück\ Westfalen",
"499642", "Kemnath\ Stadt",
"499664", "Hahnbach",
"4939973", "Altkalen",
"495838", "Gross\ Oesingen",
"492643", "Altenahr",
"494135", "Kirchgellersen",
"497244", "Weingarten\ Baden",
"499076", "Wittislingen",
"494945", "Grossefehn\-Timmel",
"496237", "Maxdorf",
"497262", "Eppingen",
"492993", "Marsberg\-Canstein",
"499933", "Wallersdorf",
"49791", "Schwäbisch\ Hall",
"492932", "Neheim\-Hüsten",
"494557", "Blunk",
"494853", "Sankt\ Michaelisdonn",
"495202", "Oerlinghausen",
"492164", "Jüchen\-Otzenrath",
"495274", "Nieheim",
"499143", "Pappenheim\ Mittelfranken",
"492844", "Rheinberg\-Orsoy",
"49271", "Siegen",
"499324", "Dettelbach",
"492586", "Beelen",
"492862", "Südlohn",
"497732", "Radolfzell\ am\ Bodensee",
"497424", "Spaichingen",
"4933748", "Treuenbrietzen",
"4939832", "Wesenberg",
"499306", "Kist",
"499567", "Sesslach\-Gemünda",
"496625", "Niederaula",
"498336", "Erkheim",
"496045", "Gedern",
"4934774", "Röblingen\ am\ See",
"495466", "Merzen",
"4933083", "Schulzendorf\ Kreis\ Oberhavel",
"496122", "Hofheim\-Wallau",
"4937365", "Sayda",
"4939852", "Schönermark\ bei\ Prenzlau",
"499401", "Neutraubling",
"499865", "Adelshofen\ Mittelfranken",
"4934745", "Winningen\ Sachsen\-Anhalt",
"4936076", "Niederorschel",
"498282", "Krumbach\ Schwaben",
"493431", "Döbeln",
"495361", "Wolfsburg",
"4939724", "Klein\ Bünzow",
"498056", "Eggstätt",
"4939264", "Kroppenstedt",
"492954", "Rüthen\-Oestereiden",
"498431", "Neuburg\ an\ der\ Donau",
"496043", "Nidda",
"496623", "Rotenburg\ an\ der\ Fulda",
"497392", "Laupheim",
"495836", "Wittingen\-Radenbeck",
"499492", "Parsberg",
"494445", "Visbek\ Kreis\ Vechta",
"498403", "Pförring",
"4938736", "Goldberg",
"4936601", "Hermsdorf\ Thüringen",
"4934973", "Osternienburg",
"494871", "Hohenwestedt",
"499078", "Mertingen",
"496386", "Altenkirchen\ Pfalz",
"4939320", "Schinne",
"494637", "Sterup",
"49931", "Würzburg",
"496295", "Rosenberg\ Baden",
"497333", "Laichingen",
"492432", "Wassenberg",
"492724", "Finnentrop\-Serkenrode",
"497055", "Neuweiler\ Kreis\ Calw",
"49741", "Rottweil",
"499433", "Nabburg",
"4933965", "Herzsprung\ bei\ Wittstock",
"499647", "Kirchenthumbach",
"498861", "Schongau",
"4939923", "Priborn",
"4938756", "Grabow",
"498405", "Stammham\ bei\ Ingolstadt",
"4936643", "Thimmendorf",
"494443", "Dinklage",
"4936450", "Kranichfeld",
"497267", "Gemmingen",
"4936423", "Orlamünde",
"493861", "Plate",
"496232", "Speyer",
"4933361", "Joachimsthal",
"495156", "Coppenbrügge",
"499435", "Schwarzenfeld",
"497053", "Bad\ Teinach\-Zavelstein",
"494552", "Leezen",
"492937", "Arnsberg\-Oeventrop",
"497335", "Wiesensteig",
"496293", "Schefflenz",
"495207", "Schloss\ Holte\-Stukenbrock",
"496744", "Oberwesel",
"49681", "Saarbrücken",
"4939745", "Hetzdorf\ bei\ Strasburg",
"492867", "Heiden\ Kreis\ Borken",
"494223", "Ganderkesee\-Bookholzberg",
"496762", "Kastellaun",
"499901", "Hengersberg\ Bayern",
"499544", "Baunach",
"4939031", "Dähre",
"4938828", "Schönberg",
"4934494", "Ehrenhain",
"492563", "Stadtlohn",
"499562", "Sonnefeld",
"492389", "Werne",
"496709", "Fürfeld\ Kreis\ Bad\ Kreuznach",
"492454", "Gangelt",
"495483", "Lienen",
"495820", "Suhlendorf",
"493931", "Stendal",
"498141", "Fürstenfeldbruck",
"496127", "Niedernhausen\ Taunus",
"497906", "Braunsbach",
"492565", "Gronau\-Epe",
"492588", "Harsewinkel\-Greffen",
"496254", "Lautertal\ Odenwald",
"4939051", "Calvörde",
"4936026", "Struth\ bei\ Mühlhausen",
"4938202", "Volkenshagen",
"4933201", "Gross\ Glienicke",
"494101", "Pinneberg",
"495966", "Meppen\-Apeldorn",
"4939774", "Mönkebude",
"498338", "Böhen",
"495468", "Bramsche\-Engter",
"495485", "Ladbergen",
"493338", "Bernau\ Brandenburg",
"49203", "Duisburg",
"494534", "Steinburg\ Kreis\ Storman",
"4939992", "Görmin",
"497935", "Schrozberg",
"492337", "Hagen\-Dahl",
"494234", "Dörverden",
"4937208", "Auerswalde",
"4939361", "Lüderitz",
"4933333", "Tantow",
"497145", "Markgröningen",
"4934381", "Colditz",
"4933923", "Flecken\ Zechlin",
"493883", "Hagenow",
"4935477", "Rietzneuendorf\-Friedrichshof",
"4933767", "Friedersdorf\ bei\ Berlin",
"494525", "Ahrensbök",
"4936042", "Tonna",
"496554", "Waxweiler",
"492265", "Reichshof\-Eckenhagen",
"495175", "Lehrte\-Arpke",
"499071", "Dillingen\ an\ der\ Donau",
"499397", "Wertheim\-Dertingen",
"4936465", "Oberndorf\ bei\ Apolda",
"495626", "Bad\ Zwesten",
"497143", "Besigheim",
"499209", "Emtmannsberg",
"495672", "Bad\ Karlshafen",
"495604", "Grossalmerode",
"4939296", "Welsleben",
"497933", "Creglingen",
"49991", "Deggendorf",
"4939349", "Parey\ Elbe",
"496465", "Breidenbach\ bei\ Biedenkopf",
"498868", "Schwabsoien",
"4937754", "Zwönitz",
"499262", "Wallenfels",
"499244", "Betzenstein",
"495173", "Uetze",
"4938457", "Krakow\ am\ See",
"492263", "Engelskirchen",
"494827", "Wacken",
"497664", "Freiburg\-Tiengen",
"494523", "Malente",
"4936966", "Kaltennordheim",
"493868", "Rastow",
"497642", "Endingen\ Kaiserstuhl",
"497022", "Nürtingen",
"498239", "Langenneufnach",
"498702", "Wörth\ an\ der\ Isar",
"495507", "Ebergötzen",
"4938844", "Gülze",
"49465", "Sylt",
"498774", "Bayerbach\ bei\ Ergoldsbach",
"495366", "Jembke",
"496897", "Sulzbach\ Saar",
"494252", "Bruchhausen\-Vilsen",
"496593", "Hillesheim\ Eifel",
"495803", "Rosche",
"493774", "Schwarzenberg",
"498051", "Prien\ am\ Chiemsee",
"497567", "Leutkirch\-Friesenhofen",
"4933051", "Nassenheide",
"499406", "Mintraching",
"496532", "Zeltingen\-Rachtig",
"497306", "Vöhringen\ Iller",
"4938429", "Glasin",
"4939201", "Wolmirstedt",
"499732", "Hammelburg",
"499908", "Schöfweg",
"499424", "Strasskirchen",
"4937368", "Deutschneudorf",
"496171", "Oberursel\ Taunus",
"4933239", "Gross\ Behnitz",
"492733", "Hilchenbach",
"497324", "Herbrechtingen",
"494108", "Rosengarten\ Kreis\ Harburg",
"495805", "Oetzen",
"498331", "Memmingen",
"496595", "Dockweiler",
"493331", "Angermünde",
"495461", "Bramsche\ Hase",
"494764", "Gnarrenburg\-Klenkendorf",
"494742", "Dorum",
"492735", "Neunkirchen\ Siegerl",
"496657", "Hofbieber",
"4938875", "Schlagsdorf\ bei\ Gadebusch",
"4933745", "Petkus",
"492581", "Warendorf",
"4939243", "Nedlitz\ bei\ Zerbst",
"495190", "Soltau\-Emmingen",
"498684", "Fridolfing",
"4939009", "Badel",
"494779", "Freiburg\ Elbe",
"492994", "Marsberg\-Westheim",
"494467", "Wittmund\-Funnix",
"4936878", "Oberland",
"497243", "Ettlingen",
"4935056", "Altenberg\ Sachsen",
"498541", "Vilshofen\ Niederbayern",
"492644", "Linz\ am\ Rhein",
"493541", "Calau",
"499663", "Neukirchen\ bei\ Sulzbach\-Rosenberg",
"493904", "Haldensleben",
"497755", "Weilheim\ Kreis\ Waldshut",
"492662", "Hachenburg",
"4934905", "Wörlitz",
"495273", "Beverungen",
"499144", "Pleinfeld",
"492163", "Schwalmtal\ Niederrhein",
"496578", "Salmtal",
"499162", "Scheinfeld",
"494854", "Friedrichskoog",
"496825", "Illingen\ Saar",
"498139", "Röhrmoos",
"493949", "Oschersleben\ Bode",
"4936604", "Münchenbernsdorf",
"499778", "Fladungen",
"498860", "Bernbeuren",
"4933364", "Gross\ Ziethen\ Kreis\ Barnim",
"497753", "Albbruck",
"499665", "Königstein\ Oberpfalz",
"494134", "Embsen\ Kreis\ Lüneburg",
"497245", "Durmersheim",
"494501", "Kastorf\ Holstein",
"494944", "Wiesmoor",
"493860", "Raben\ Steinfeld",
"494962", "Papenburg\-Aschendorf",
"4933979", "Wusterhausen\ Dosse",
"499727", "Schonungen\-Marktsteinach",
"496342", "Schweigen\-Rechtenbach",
"49421", "Bremen",
"496364", "Nussbach\ Pfalz",
"496527", "Oberweis",
"492165", "Jüchen",
"4934343", "Regis\-Breitingen",
"495275", "Höxter\-Ottbergen",
"4934261", "Kühren\ bei\ Wurzen",
"492845", "Neukirchen\-Vluyn",
"499325", "Kleinlangheim",
"494208", "Grasberg",
"4935453", "Drahnsdorf",
"4935605", "Komptendorf",
"494893", "Hohenaspe",
"497425", "Trossingen",
"4934721", "Nienburg\ Saale",
"492471", "Roetgen\ Eifel",
"496044", "Schotten\ Hessen",
"496624", "Heringen\ Werra",
"492953", "Wünnenberg",
"496062", "Erbach\ Odenwald",
"499952", "Eichendorf",
"4934491", "Schmölln\ Thüringen",
"4939034", "Fleetmark",
"494832", "Meldorf",
"495821", "Bad\ Bevensen",
"492547", "Rosendahl\-Osterwick",
"4939771", "Ueckermünde",
"495198", "Schneverdingen\-Wintermoor",
"4939089", "Bismark\ Altmark",
"4937329", "Grosshartmannsdorf",
"497423", "Oberndorf\ am\ Neckar",
"498248", "Lamerdingen",
"495556", "Lindau\ Harz",
"499842", "Uffenheim",
"4935433", "Vetschau",
"494152", "Geesthacht",
"499323", "Iphofen",
"492843", "Rheinberg",
"4939054", "Flechtingen",
"496271", "Eberbach\ Baden",
"4933204", "Beelitz\ Mark",
"492955", "Büren\-Wewelsburg",
"497357", "Attenweiler",
"4937462", "Rothenkirchen\ Vogtland",
"495082", "Langlingen",
"496571", "Wittlich",
"496132", "Ingelheim\ am\ Rhein",
"499771", "Bad\ Neustadt\ an\ der\ Saale",
"496692", "Neustadt\ Hessen",
"4939826", "Blankensee\ bei\ Neustrelitz",
"498548", "Vilshofen\-Sandbach",
"4939364", "Dolle",
"498421", "Eichstätt\ Bayern",
"496633", "Homberg\ Ohm",
"4937292", "Oederan",
"493421", "Torgau",
"494362", "Heiligenhafen",
"494344", "Schönberg\ Holstein",
"492247", "Neunkirchen\-Seelscheid",
"4934384", "Grossbothen",
"499070", "Tapfheim",
"498349", "Stötten\ am\ Auerberg",
"499334", "Giebelstadt",
"496447", "Langgöns\-Niederkleen",
"492181", "Grevenbroich",
"497434", "Winterlingen",
"497722", "Triberg\ im\ Schwarzwald",
"498304", "Wildpoldsried",
"495746", "Rödinghausen",
"498372", "Obergünzburg",
"4934929", "Straach",
"494297", "Ottersberg\-Posthausen",
"492394", "Neuenrade\-Affeln",
"499681", "Windischeschenbach",
"496635", "Kirtorf",
"498326", "Fischen\ im\ Allgäu",
"494508", "Krummesse",
"49340", "Dessau\ Anh",
"4935206", "Kreischa\ bei\ Dresden",
"496852", "Nohfelden",
"493304", "Velten",
"496195", "Kelkheim\ Taunus",
"493372", "Jüterbog",
"496154", "Ober\-Ramstadt",
"4933054", "Liebenwalde",
"496227", "Walldorf\ Baden",
"497957", "Kressberg",
"492355", "Schalksmühle",
"4939204", "Niederndodeleben",
"49451", "Lübeck",
"495828", "Himbergen",
"494125", "Seestermühe",
"4938841", "Neuhaus\ Elbe",
"498074", "Schnaitsee",
"499093", "Polsingen",
"497545", "Immenstaad\ am\ Bodensee",
"4934602", "Landsberg\ Sachsen\-Anhalt",
"499923", "Teisnach",
"492922", "Werl",
"498751", "Mainburg",
"498666", "Teisendorf",
"4933089", "Himmelpfort",
"494123", "Barmstedt",
"495459", "Hörstel",
"499352", "Lohr\ am\ Main",
"495384", "Seesen\-Gross\ Rhüden",
"492353", "Halver",
"497452", "Nagold",
"498330", "Legau",
"495573", "Uslar\-Volpriehausen",
"4934327", "Waldheim\ Sachsen",
"4935752", "Ruhland",
"4938485", "Dabel",
"496834", "Bous",
"492427", "Nideggen",
"499925", "Bayerisch\ Eisenstein",
"498241", "Buchloe",
"495191", "Soltau",
"497543", "Kressbronn\ am\ Bodensee",
"494622", "Taarstedt",
"495631", "Korbach",
"495754", "Extertal\-Bremke",
"494451", "Varel\ Jadebusen",
"496303", "Enkenbach\-Alsenborn",
"496582", "Freudenburg",
"499175", "Spalt",
"495071", "Schwarmstedt",
"4935796", "Panschwitz\-Kuckau",
"4934297", "Liebertwolkwitz",
"496866", "Perl\-Nennig",
"492675", "Ediger\-Eller",
"493965", "Burow\ bei\ Altentreptow",
"4934467", "Eckartsberga",
"497158", "Neuhausen\ auf\ den\ Fildern",
"497041", "Mühlacker",
"497621", "Lörrach",
"4935951", "Neukirch\ Lausitz",
"4939487", "Friedrichsbrunn",
"494639", "Schafflund",
"494973", "Wittmund\-Burhafe",
"498634", "Garching\ an\ der\ Alz",
"492104", "Mettmann",
"495262", "Extertal",
"499173", "Thalmässing",
"498194", "Vilgertshofen",
"495244", "Rietberg",
"497269", "Sulzfeld\ Baden",
"496305", "Hochspeyer",
"497838", "Nordrach",
"4938375", "Koserow",
"493634", "Sömmerda",
"497250", "Kraichtal",
"494356", "Gross\ Wittensee",
"493381", "Brandenburg\ an\ der\ Havel",
"497202", "Karlsbad",
"494975", "Westerholt\ Ostfriesland",
"499626", "Hohenburg",
"4935931", "Königswartha",
"497274", "Germersheim",
"495209", "Gütersloh\-Friedrichsdorf",
"499672", "Neunburg\ vorm\ Wald",
"49760", "Oberried\ Breisgau",
"493963", "Woldegk",
"499604", "Wernberg\-Köblitz",
"492673", "Ellenz\-Poltersdorf",
"498381", "Lindenberg\ im\ Allgäu",
"4933972", "Breddin",
"49591", "Lingen\ \(Ems\)",
"492238", "Pulheim",
"495406", "Belm",
"493537", "Jessen\ Elster",
"492850", "Rees\-Haldern",
"498537", "Bad\ Füssing\-Aigen",
"494721", "Cuxhaven",
"495908", "Wietmarschen\-Lohne",
"495732", "Löhne",
"495424", "Bad\ Rothenfelde",
"4935693", "Lauschütz",
"4937607", "Ebersbrunn\ Sachsen",
"497739", "Hilzingen",
"497466", "Beuron",
"4933833", "Wollin\ bei\ Brandenburg",
"499366", "Geroldshausen\ Unterfranken",
"4934651", "Rossla",
"492802", "Alpen",
"496707", "Windesheim",
"492387", "Drensteinfurt\-Walstedde",
"494284", "Selsingen",
"492874", "Isselburg",
"4935023", "Bad\ Gottleuba",
"499803", "Colmberg",
"4939861", "Gramzow\ bei\ Prenzlau",
"4936924", "Mihla",
"496073", "Babenhausen\ Hessen",
"499190", "Heroldsbach",
"496129", "Schlangenbad",
"498652", "Berchtesgaden",
"4939424", "Schwanebeck\ Sachsen\-Anhalt",
"495301", "Lehre\-Essenrode",
"499805", "Burgoberbach",
"496146", "Hochheim\ am\ Main",
"4934445", "Stössen",
"498153", "Wessling",
"496438", "Hünfelden",
"4934242", "Hohenpriessnitz",
"499461", "Roding",
"4939082", "Mieste",
"4937322", "Brand\-Erbisdorf",
"497361", "Aalen",
"4936334", "Wolkramshausen",
"498363", "Pfronten",
"498824", "Oberau\ Loisach",
"4935267", "Diesbar\-Seusslitz",
"493981", "Neustrelitz",
"498806", "Utting\ am\ Ammersee",
"497628", "Efringen\-Kirchen",
"492339", "Sprockhövel\-Hasslinghausen",
"49531", "Braunschweig",
"497151", "Waiblingen",
"4939972", "Walkendorf",
"4937346", "Geyer",
"495433", "Badbergen",
"4935727", "Burghammer",
"494458", "Wiefelstede\-Spohle",
"49355", "Cottbus",
"4938328", "Miltzow",
"499836", "Gunzenhausen\-Cronheim",
"495492", "Steinfeld\ Oldenburg",
"494956", "Uplengen",
"4936785", "Gräfinau\-Angstedt",
"499156", "Neuhaus\ an\ der\ Pegnitz",
"495435", "Berge\ bei\ Quakenbrück",
"49208", "Oberhausen\ Rheinland",
"494846", "Hattstedt",
"4934922", "Mühlanger",
"499207", "Königsfeld\ Oberfranken",
"498388", "Hergensweiler",
"498365", "Wertach",
"495647", "Lichtenau\-Kleinenberg",
"495027", "Linsburg",
"498237", "Aindling",
"492656", "Virneburg",
"492761", "Olpe\ Biggesee",
"497831", "Hausach",
"494829", "Wewelsfleth",
"492538", "Drensteinfurt\-Rinkerode",
"4933849", "Wiesenburg\ Mark",
"497383", "Münsingen\-Buttenhausen",
"492482", "Hellenthal",
"496336", "Dellfeld",
"495509", "Rosdorf\ Kreis\ Göttingen",
"498045", "Lenggries\-Fall",
"4939853", "Holzendorf\ bei\ Prenzlau",
"4934609", "Salzmünde",
"497961", "Ellwangen\ Jagst",
"497502", "Wolpertswende",
"4939820", "Triepkendorf",
"499820", "Lehrberg",
"497574", "Gammertingen",
"4933082", "Menz\ Kreis\ Oberhavel",
"495544", "Reinhardshagen",
"494166", "Ahlerstedt",
"495901", "Fürstenau\ bei\ Bramsche",
"497569", "Isny\-Eisenbach",
"4938234", "Born\ Darss",
"495562", "Dassel\-Markoldendorf",
"496056", "Bad\ Soden\-Salmünster",
"499966", "Wiesenfelden",
"4935245", "Burkhardswalde\-Munzig",
"496431", "Limburg\ an\ der\ Lahn",
"498043", "Jachenau",
"4935200", "Arnsdorf\ bei\ Dresden",
"4939833", "Mirow\ Kreis\ Neustrelitz",
"4936077", "Grossbodungen",
"498623", "Kirchweidach",
"493623", "Friedrichroda",
"4933675", "Tauche",
"499468", "Zell\ Oberpfalz",
"4936948", "Römhild",
"497385", "Gomadingen",
"496660", "Steinau\-Marjoss",
"498176", "Egling\ bei\ Wolfratshausen",
"494777", "Cadenberge",
"496282", "Walldürn",
"498122", "Erding",
"496659", "Eichenzell",
"495308", "Lehre",
"498555", "Perlesreut",
"499256", "Stammbach",
"496328", "Elmstein",
"494469", "Wangerooge",
"497741", "Tiengen\ Hochrhein",
"499107", "Trautskirchen",
"4935954", "Grossharthau",
"495054", "Bergen\-Sülze",
"498137", "Petershausen",
"493947", "Thale",
"492607", "Kobern\-Gondorf",
"499082", "Oettingen\ in\ Bayern",
"494736", "Butjadingen\-Tossens",
"497620", "Schopfheim\-Gersbach",
"495771", "Rahden\ Westfalen",
"494402", "Rastede",
"494474", "Garrel",
"498857", "Benediktbeuern",
"4935934", "Grossdubrau",
"499746", "Zeitlofs",
"495681", "Homberg\ Efze",
"4938303", "Sellin\ Ostseebad",
"498553", "Spiegelau",
"497251", "Bruchsal",
"498442", "Wolnzach",
"4936020", "Ebeleben",
"4936705", "Oberweissbach\ Thüringer\ Wald",
"498464", "Dietfurt\ an\ der\ Altmühl",
"4935324", "Crinitz",
"495334", "Hornburg\ Kreis\ Wolfenbüttel",
"493464", "Sangerhausen",
"499729", "Grettstadt",
"498380", "Achberg",
"497558", "Illmensee",
"4934654", "Stolberg\ Harz",
"497636", "Münstertal\ Schwarzwald",
"492851", "Rees",
"4935387", "Seyda",
"496007", "Rosbach\-Rodheim",
"495923", "Schüttorf",
"496683", "Ehrenberg\ Rhön",
"496182", "Seligenstadt",
"499575", "Weismain",
"498276", "Baar\ Schwaben",
"4938788", "Gross\ Warnow",
"494641", "Süderbrarup",
"4939455", "Schierke",
"4939603", "Burg\ Stargard",
"496775", "Strüth\ Taunus",
"495032", "Neustadt\ am\ Rübenberge",
"499828", "Rügland",
"498222", "Burgau\ Schwaben",
"496668", "Birstein\-Lichenroth",
"495925", "Wietmarschen",
"499191", "Forchheim\ Oberfranken",
"495300", "Salzgitter\-Üfingen",
"4936331", "Ilfeld",
"499631", "Tirschenreuth",
"495352", "Schöningen",
"493594", "Bischofswerda",
"499384", "Schwanfeld",
"492526", "Sendenhorst",
"492691", "Adenau",
"496773", "Kamp\-Bornhofen",
"4936921", "Wutha\-Farnroda",
"492131", "Neuss",
"497484", "Simmersfeld",
"4938750", "Malliss",
"492572", "Emsdetten",
"493601", "Mühlhausen\ Thüringen",
"492504", "Telgte",
"492941", "Lippstadt",
"499573", "Staffelstein\ Oberfranken",
"4939956", "Neukalen",
"494266", "Brockel",
"4938723", "Kladrum",
"4933397", "Wandlitz",
"4938209", "Sanitz\ bei\ Rostock",
"4939421", "Osterwieck",
"495144", "Wathlingen",
"499273", "Bad\ Berneck\ im\ Fichtelgebirge",
"498294", "Horgau",
"492272", "Bedburg\ Erft",
"494882", "Lunden",
"495162", "Fallingbostel",
"494307", "Raisdorf",
"4936652", "Wurzbach",
"492204", "Bensberg",
"497150", "Korntal\-Münchingen",
"4936203", "Vieselbach",
"495934", "Haren\-Rütenbrock",
"4939407", "Seehausen\ Börde",
"492226", "Rheinbach",
"4939999", "Tutow",
"495109", "Ronnenberg",
"49861", "Traunstein",
"496321", "Neustadt\ an\ der\ Weinstrasse",
"497174", "Mögglingen",
"497748", "Grafenhausen\ Hochschwarzwald",
"495663", "Spangenberg",
"49361", "Erfurt",
"496449", "Ehringshausen\-Katzenfurt",
"493576", "Weisswasser",
"498347", "Friesenried",
"4933877", "Nitzahn",
"499275", "Speichersdorf",
"493522", "Grossenhain\ Sachsen",
"496404", "Lich\ Hessen",
"492759", "Bad\ Berleburg\-Aue",
"496472", "Weilmünster",
"495665", "Guxhagen",
"496426", "Fronhausen",
"497258", "Oberderdingen\-Flehingen",
"4939342", "Gladau",
"4933435", "Rehfelde",
"497959", "Frankenhardt",
"495952", "Sögel",
"4938225", "Trinwillershagen",
"4936737", "Drognitz",
"4938422", "Neukloster",
"494496", "Friesoythe\-Markhausen",
"4939397", "Geestgottberg",
"498067", "Tuntenhausen",
"4938231", "Barth",
"4933232", "Brieselang",
"496229", "Neckarsteinach",
"497551", "Überlingen\ Bodensee",
"498253", "Pöttmes",
"495325", "Goslar\-Hahnenklee",
"493745", "Falkenstein\ Vogtland",
"492858", "Hünxe",
"496246", "Eich\ Rheinhessen",
"498745", "Bodenkirchen",
"4936378", "Ostramondra",
"4938792", "Lenzen\ \(Elbe\)",
"494703", "Loxstedt\-Donnern",
"492446", "Heimbach\ Eifel",
"497826", "Schuttertal",
"496430", "Hahnstätten",
"492948", "Lippstadt\-Rebbeke",
"4939002", "Oebisfelde",
"495457", "Hopsten\-Schale",
"4933603", "Falkenhagen\ bei\ Seelow",
"497804", "Oppenau",
"496661", "Schlüchtern",
"496756", "Winterbach\ Soonwald",
"494705", "Wremen",
"498743", "Geisenhausen",
"499198", "Heiligenstadt\ in\ Oberfranken",
"492429", "Hürtgenwald",
"499556", "Geiselwind",
"495842", "Schnega",
"495323", "Clausthal\-Zellerfeld",
"499638", "Neualbenreuth",
"495864", "Jameln",
"494184", "Hanstedt\ Nordheide",
"498825", "Krün",
"493578", "Kamenz",
"496139", "Budenheim",
"494302", "Kirchbarkau",
"495167", "Walsrode\-Westenholz",
"4936081", "Arenshausen",
"497082", "Neuenbürg\ Württemberg",
"4935057", "Hermsdorf\ Erzgebirge",
"4934342", "Neukieritzsch",
"495686", "Schwarzenborn\ Knüll",
"499741", "Bad\ Brückenau",
"4937431", "Mehltheuer\ Vogtland",
"4937600", "Neumark\ Sachsen",
"497256", "Philippsburg",
"496096", "Wiesen\ Unterfranken",
"496428", "Stadtallendorf",
"496541", "Traben\-Trarbach",
"494731", "Nordenham",
"495722", "Bückeburg",
"495434", "Essen\ Oldenburg",
"493364", "Eisenhüttenstadt",
"493342", "Neuenhagen\ bei\ Berlin",
"497729", "Tennenbronn",
"492228", "Remagen\-Rolandseck",
"498342", "Marktoberdorf",
"495776", "Preussisch\ Ströhen",
"498364", "Seeg",
"498823", "Mittenwald",
"496477", "Greifenstein\-Nenderoth",
"499251", "Münchberg",
"493379", "Mahlow",
"498379", "Waltenhofen\-Oberdorf",
"4936254", "Friedrichswerth",
"497746", "Wutöschingen",
"495957", "Lindern\ Oldenburg",
"493624", "Ohrdruf",
"492521", "Beckum",
"492696", "Nohn\ Eifel",
"492448", "Hellenthal\-Rescheid",
"494261", "Rotenburg\ Wümme",
"498624", "Obing",
"493606", "Heiligenstadt\ Heilbad",
"498062", "Bruckmühl\ Mangfall",
"497575", "Messkirch",
"496758", "Waldböckelheim",
"495545", "Hedemünden",
"499636", "Plössberg",
"4933654", "Fünfeichen",
"499196", "Wiesenttal",
"497573", "Stetten\ am\ kalten\ Markt",
"498271", "Meitingen",
"499360", "Thüngen",
"4939458", "Heudeber",
"495452", "Mettingen\ Westfalen",
"4935894", "Hähnichen",
"499359", "Karlstadt\-Wiesenfeld",
"4938785", "Berge\ bei\ Perleberg",
"499484", "Brennberg",
"4935452", "Golssen",
"494498", "Saterland\-Ramsloh",
"494646", "Mohrkirch",
"497459", "Nagold\-Hochdorf",
"4933839", "Wusterwitz",
"497384", "Schelklingen\-Hütten",
"492856", "Hamminkeln\-Brünen",
"497631", "Müllheim\ Baden",
"4933634", "Berkenbrück\ Kreis\ Oder\-Spree",
"497191", "Backnang",
"495543", "Staufenberg\ Niedersachsen",
"495755", "Kalletal\-Varenholz",
"499748", "Motten",
"499102", "Wilhermsdorf",
"499174", "Hilpoltstein",
"498193", "Geltendorf",
"492103", "Hilden",
"496421", "Marburg",
"498633", "Tüssling",
"499087", "Marktoffingen",
"493571", "Hoyerswerda",
"492602", "Montabaur",
"492674", "Bad\ Bertrich",
"493964", "Bredenfelde\ bei\ Strasburg",
"499603", "Floss",
"4939827", "Schwarz\ bei\ Neustrelitz",
"4938354", "Wusterhusen",
"498571", "Simbach\ am\ Inn",
"497273", "Hagenbach\ Pfalz",
"494407", "Wardenburg",
"492066", "Duisburg\-Homberg",
"496326", "Deidesheim",
"498635", "Pleiskirchen",
"495245", "Herzebrock\-Clarholz",
"498195", "Weil\ Kreis\ Landsberg\ am\ Lech",
"496304", "Wolfstein\ Pfalz",
"496372", "Bruchmühlbach\-Miesau",
"493635", "Kölleda",
"495753", "Auetal\-Bernsen",
"494950", "Holtland",
"4937463", "Bergen\ Vogtland",
"4935207", "Moritzburg",
"494974", "Neuharlingersiel",
"497275", "Kandel",
"494902", "Jemgum\-Ditzum",
"4938334", "Grammendorf",
"494561", "Neustadt\ in\ Holstein",
"4937293", "Eppendorf\ Sachsen",
"496349", "Billigheim\-Ingenheim",
"499605", "Weiherhammer",
"493447", "Altenburg\ Thüringen",
"498170", "Strasslach\-Dingharting",
"496666", "Freiensteinau",
"496751", "Bad\ Sobernheim",
"496002", "Ober\-Mörlen",
"495425", "Borgholzhausen",
"496074", "Rödermark",
"4930", "Berlin",
"499551", "Burgwindheim",
"496187", "Schöneck",
"4933458", "Falkenberg\ Mark",
"4934956", "Zörbig",
"497821", "Lahr\ Schwarzwald",
"492441", "Kall",
"496050", "Biebergemünd",
"494839", "Wöhrden\ Dithmarschen",
"492528", "Ennigerloh\-Enniger",
"495037", "Bad\ Rehburg",
"494285", "Rhade\ bei\ Zeven",
"494268", "Bötersen",
"4935753", "Grossräschen",
"496241", "Worms",
"4936375", "Kindelbrück",
"495423", "Versmold",
"494159", "Basthorst",
"493834", "Greifswald",
"497556", "Uhldingen\-Mühlhofen",
"4939884", "Hassleben\ bei\ Prenzlau",
"499872", "Heilsbronn",
"495357", "Grasleben",
"499804", "Aurach",
"492873", "Isselburg\-Werth",
"494283", "Tarmstedt",
"4939859", "Fürstenwerder",
"4934603", "Nauendorf\ Sachsen\-Anhalt",
"4938228", "Dettmannsdorf\-Kölzow",
"499826", "Weidenbach\ Mittelfranken",
"4933438", "Altlandsberg",
"4933843", "Niemegk",
"494491", "Friesoythe",
"498295", "Altenmünster\ Schwaben",
"495145", "Beedenbostel",
"4938737", "Ganzlin",
"4936422", "Reinstädt\ Thüringen",
"494848", "Rantrum",
"493386", "Premnitz",
"499158", "Offenhausen\ Mittelfranken",
"4937434", "Bobenneukirchen",
"492205", "Rösrath",
"499621", "Amberg\ Oberpfalz",
"4936642", "Harra",
"498386", "Oberstaufen",
"4939922", "Dambeck\ bei\ Röbel",
"495935", "Twist\-Schöninghsdorf",
"4938378", "Heringsdorf\ Seebad",
"4936084", "Heuthen",
"4938309", "Trent",
"497175", "Leinzell",
"492536", "Münster\-Albachten",
"494351", "Eckernförde",
"496403", "Linden\ Hessen",
"495933", "Lathen",
"4939226", "Hohenziatz",
"497672", "St\ Blasien",
"492203", "Cologne\-Porz",
"499202", "Waischenfeld",
"4938757", "Neustadt\-Glewe",
"498808", "Pähl",
"497626", "Kandern",
"495143", "Winsen\ Aller",
"498293", "Welden\ bei\ Augsburg",
"499274", "Hollfeld",
"497046", "Zaberfeld",
"496405", "Laubach\ Hessen",
"495022", "Wietzen",
"495642", "Warburg\-Scherfede",
"495664", "Morschen",
"494456", "Varel\-Altjührden",
"498232", "Schwabmünchen",
"497173", "Heubach",
"496861", "Merzig",
"499269", "Tettau\ Kreis\ Kronach",
"494958", "Jemgum",
"497803", "Gengenbach",
"4938203", "Bad\ Doberan",
"4938729", "Marnitz",
"496058", "Gründau",
"492520", "Wadersloh\-Diestedde",
"497366", "Abtsgmünd",
"498709", "Eching\ Niederbayern",
"494260", "Visselhövede\-Wittorf",
"494682", "Amrum",
"499466", "Stamsried",
"494183", "Jesteburg",
"495324", "Vienenburg",
"493762", "Crimmitschau",
"495863", "Zernien",
"493744", "Auerbach\ Vogtland",
"498178", "Icking",
"49381", "Rostock",
"498744", "Gerzen",
"4933474", "Neutrebbin",
"49881", "Weilheim\ in\ Oberbayern",
"495306", "Cremlingen",
"498762", "Wartenberg\ Oberbayern",
"4933631", "Bad\ Saarow\-Pieskow",
"494749", "Schiffdorf\-Geestenseth",
"497461", "Tuttlingen",
"4936027", "Lengenfeld\ Unterm\ Stein",
"492982", "Medebach",
"497805", "Appenweier",
"496338", "Hornbach\ Pfalz",
"496287", "Limbach\ Baden",
"494704", "Drangstedt",
"495401", "Georgsmarienhütte",
"494772", "Oberndorf\ Oste",
"4935891", "Rothenburg\ OL",
"495865", "Gusborn",
"498254", "Altomünster",
"494168", "Neu\ Wulmstorf\-Elstorf",
"494185", "Marxen\ Auetal",
"498554", "Schönberg\ Niederbayern",
"494358", "Loose\ bei\ Eckernförde",
"496587", "Zerf",
"4938351", "Mesekenhagen",
"499499", "Painten",
"497836", "Schiltach",
"492651", "Mayen",
"496420", "Lahntal",
"494841", "Husum\ Nordsee",
"495055", "Fassberg",
"49541", "Osnabrück",
"499628", "Ursensollen",
"495333", "Dettum",
"499151", "Hersbruck",
"498463", "Greding",
"4939390", "Iden",
"4935476", "Wittmannsdorf\-Bückchen",
"494475", "Molbergen",
"4936730", "Sitzendorf",
"4933766", "Teupitz",
"4939297", "Eickendorf\ Kreis\ Schönebeck",
"4933332", "Gartz\ Oder",
"4938331", "Rakow\ Vorpom",
"499831", "Gunzenhausen",
"496239", "Bobenheim\-Roxheim",
"496868", "Mettlach\-Tünsdorf",
"494951", "Weener",
"4939993", "Hohenmocker",
"4938325", "Rolofshagen",
"494473", "Emstek",
"4936967", "Geisa",
"4936209", "Klettbach",
"4936043", "Kirchheilingen",
"498465", "Kipfenberg",
"4935975", "Hohnstein",
"499677", "Oberviechtach\-Pullenried",
"495335", "Schladen",
"494559", "Wensin",
"4938456", "Langhagen\ bei\ Güstrow",
"498801", "Seeshaupt",
"4933922", "Karwesee",
"495053", "Fassberg\-Müden",
"497156", "Ditzingen",
"4934424", "Reuden\ bei\ Zeitz",
"498171", "Wolfratshausen",
"499569", "Sesslach",
"498532", "Griesbach\ im\ Rottal",
"496436", "Dornburg\ Hessen",
"499502", "Frensdorf",
"4936945", "Henneberg",
"4933609", "Brieskow\-Finkenheerd",
"498593", "Untergriesbach",
"499574", "Marktzeuln",
"4933678", "Storkow\ Mark",
"492440", "Nettersheim\-Tondorf",
"499961", "Mitterfels",
"496051", "Gelnhausen",
"4939242", "Prödel",
"4935248", "Schönfeld\ bei\ Grossenhain",
"497483", "Horb\-Mühringen",
"492382", "Ahlen\ Westfalen",
"4939400", "Wefensleben",
"496774", "Kaub",
"499383", "Wiesentheid",
"4939062", "Bebertal",
"496684", "Hofbieber\-Schwarzbach",
"495924", "Bad\ Bentheim\-Gildehaus",
"492236", "Wesseling\ Rheinland",
"498657", "Ramsau\ bei\ Berchtesgaden",
"495906", "Lünne",
"494161", "Buxtehude",
"499385", "Kolitzheim",
"4936626", "Auma",
"497485", "Empfingen",
"4939881", "Ringenwalde\ bei\ Templin",
"4933870", "Zollchow\ bei\ Rathenow",
"492505", "Altenberge\ Westfalen",
"496331", "Pirmasens",
"497966", "Unterschneidheim",};
$areanames{de} = {"499242", "Gößweinstein",
"4936484", "Knau\ bei\ Pößneck",
"4935841", "Großschönau\ Sachsen",
"497355", "Hochdorf\ Riß",
"496252", "Heppenheim\ Bergstraße",
"4934901", "Roßlau\ Elbe",
"4936072", "Weißenborn\-Lüderode",
"4989", "München",
"499656", "Moosbach\ bei\ Vohenstrauß",
"494684", "Langeneß\ Hallig",
"4939976", "Groß\ Bützin",
"498367", "Roßhaupten\ Forggensee",
"4935938", "Großpostwitz\ OL",
"497162", "Süßen",
"499567", "Seßlach\-Gemünda",
"4935726", "Groß\ Särchen",
"495384", "Seesen\-Groß\ Rhüden",
"496364", "Nußbach\ Pfalz",
"4938234", "Born\ Darß",
"492339", "Sprockhövel\-Haßlinghausen",
"4934445", "Stößen",
"496321", "Neustadt\ an\ der\ Weinstraße",
"4936705", "Oberweißbach\ Thüringer\ Wald",
"4935753", "Großräschen",
"498170", "Straßlach\-Dingharting",
"498633", "Tüßling",
"499636", "Plößberg",
"4935248", "Schönfeld\ bei\ Großenhain",
"495053", "Faßberg\-Müden",
"492203", "Köln\-Porz",
"4935240", "Tauscha\ bei\ Großenhain",
"49221", "Köln",
"4939883", "Groß\ Dölln",
"496663", "Steinau\ an\ der\ Straße",
"4935952", "Großröhrsdorf\ OL",
"4934493", "Gößnitz\ Thüringen",
"499141", "Weißenburg\ in\ Bayern",
"493647", "Pößneck",
"494509", "Groß\ Grönau",
"4936949", "Obermaßfeld\-Grimmenthal",
"49911", "Nürnberg",
"498536", "Kößlarn",
"498807", "Dießen\ am\ Ammersee",
"494497", "Barßel\-Harkebrügge",
"497351", "Biberach\ an\ der\ Riß",
"495827", "Unterlüß",
"4939934", "Groß\ Plasten",
"494483", "Ovelgönne\-Großenmeer",
"495064", "Groß\ Düngen",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+49|\D)//g;
      my $self = bless({ country_code => '49', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ country_code => '49', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;