/* LaBrea
 * A program to create a tar pit for the connection attempts to
 * a block of ip addresses. LaBrea sits and listens for ARP
 * "who-has" requests.  When an ARP request for a particular IP goes
 * unanswered for longer than it's "rate" setting (default: 3 seconds),
 * LaBrea crafts an ARP reply that routes all traffic destined for the IP
 * to a "bogus" MAC address.  LaBrea then listens for TCP/IP traffic
 * routed to that MAC address and then responds to any SYN packet with a
 * SYN/ACK packet that it creates.
 *
 * LaBrea completely ignores any other input.  This, forces the "client"
 * to wait for its TCP stack to time-out the connection.  Because stacks
 * tend to be a bit tenacious about "established" connections, this
 * should bog down the scanner for quite a long while.
 *
 * Many thanks to Donald Smith for suggestions and improvements and
 * to Rick Downes of Radsoft for his help and encouragement.
 *
 * Additional thanks to the following beta testers for all their help:
 * Barton Bruce, Ben Curran, Andrew Daviel, Bill Dodd, Becky Pinkard, and
 * "Micropterus Salmoides".  Also, many thanks to Matthew Franz for his help
 * in putting together the Trinux package.  Thanks also to Anders Reed Mohn
 * for his suggestions.
 *
 * THIS PROGRAM REQUIRES BOTH LIBNET and LIBPCAP in order to compile.
 *
 * Copyright (C) 2001, 2002 Tom Liston <tliston@premmag.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include "labrea.h"
#include "Data.c"
#include "GoDaemon.c"

static char texpr[65536];
short throttlesize = 10;
int dlsize = 0, star = 0, fflag = 0, sflag = 0, nkotbcount = 0, currentrand1=0;
int logopen = 0, datalog = 0, rate = 3, xflag = 0, hflag = 0, aflag = 0, Pflag = 0;
int currentbandwidth = 0, maxbw = 0, pflag = 0, past[5] = {0,0,0,0,0}, oflag = 0;
int bflag = 0, qflag = 0, savedatalog = 0, newthisminute = 0, rflag = 0, testflag = 0;
int mutexseq = 0, Xflag = 0, Oflag = 0, totalbw = 0, Hflag = 0, currentrand2 = 0;
char *dev = NULL, mybuffer[1024], mybuffer2[1024], tnow[100];
struct libnet_link_int *plnk = NULL;
struct ignore_ip *ignorelist = NULL;
unsigned char ignoreport[8192];
unsigned long base, topend, myip, randqueue1[RANDSIZE1], randqueue2[RANDSIZE2];
time_t *time_array = NULL, now;
pcap_t *pc = NULL;
u_int addresses, *addr_array = NULL;
u_char *sha, *exclusion = NULL, MACAddr[6];
struct kotb *nkotbstart = NULL, *nkotbend = NULL;
unsigned char mask[8] = {1, 2, 4, 8, 16, 32, 64, 128};
#ifdef WIN32
int boolThread = 0;
#endif

static void __inline Usage(void) {
  extern char helpstring[];

  printf(helpstring);
  CleanExit(0);
}

/* used to clean up stuff in */
/* in the input files, this  */
/* changes line feeds and    */
/* carriage returns to spaces*/
static void cleanup2(char *p) {
  while(*p != '\0') {
    if((*p == '\r') || (*p == '\n'))
      *p = ' ';
    p++;
  }
}

int main(int argc, char **argv) {
  int c, dlink, usernet = 0, zflag = 0, dflag = 0;
  char ebuf[PCAP_ERRBUF_SIZE], *p = NULL, *ffname = NULL;
  char *pnet = NULL, *pmask = NULL, boolContinue = 1, *rtn;
#ifndef WIN32
  sigset_t set;
#else
  char devicename[50];
  char *pi, *po, ch, ipaddr[20]="";
  int len, interf, dummy;
#endif
  struct bpf_program bpfp;
  bpf_u_int32 net, mask;
  FILE *in = NULL;

#ifndef WIN32
  sigemptyset(&set);
  sigprocmask(SIG_SETMASK, &set, NULL);
#endif
  /* set signals so that we behave nicely */
  signal(SIGTERM, CleanExit);
  signal(SIGINT, CleanExit);
#ifndef WIN32
  signal(SIGQUIT, CleanExit);
  signal(SIGHUP, CleanExit);
  signal(SIGALRM, ServiceTimer);
  signal(SIGUSR1, ToggleLogging);
#endif
  libnet_seed_prand();
  /* parse the command line */
  while((c = getopt(argc, argv, getoptstr)) != EOF) {
    switch(c) {
      case 'X':
        Xflag = 1;
        break;
      case 'O':
        Oflag = oflag = dflag = 1;
        break;
      case 'T':
        testflag = 1;
        break;
      case 'R':
        rflag = 5;
        break;
      case 'o':
        oflag = 1;
        dflag = 1;
        break;
      case 'd':
        dflag = 1;
        break;
      case 'x':
        xflag = 1;
        break;
      case 'b':
        bflag = 1;
        break;
      case 'v':
        datalog += 2;
        break;
      case 'z':
        zflag = 1;
        break;
      case 's':
        sflag = 1;
        break;
      case 'q':
        qflag = 1;
        break;
      case 'a':
        aflag = 1;
        break;
      case 'l':
        datalog += 1;
        break;
      case 'n':
        pnet = optarg;
        break;
      case 'm':
        pmask = optarg;
        break;
      case 'F':
        ffname = optarg;
        break;
      case 'f':
        fflag = 1;
      case 'i':
        dev = optarg;
        break;
#ifdef WIN32
      case 'D':
        if((po = pcap_lookupdev(ebuf)) == NULL) {
          rtn = err9;
          goto ErrorExit;
        }
        PrintDeviceList(po);
        CleanExit(0);
        break;
      case 'E':
        for(len = 12, pi = optarg, po = MACAddr; len > 0; pi++, po++, len -= 2) {
          while(*pi && (*pi == ' ' || *pi == ':' || *pi == '-'))
            pi++;
          ch = tolower(*pi++) - '0';
          if(ch > 9)
            ch -= ('0'-9);
          *po = ch<<4;
          ch = tolower(*pi)-'0';
          if(ch > 9)
            ch-=('0'-9);
          *po |= ch;
        }
        sha = MACAddr;
        break;
      case 'I':
        strncpy(ipaddr,optarg,18);
        ipaddr[18]=0;
        break;
#endif
      case 't':
        throttlesize = atoi(optarg);
        break;
      case 'r':
        rate = atoi(optarg);
        break;
      case 'h':
        hflag = 1;
        break;
      case 'H':
        hflag = 1;
        Hflag = 1;
        break;
      case '?':
        Usage();
        break;
      case 'P':
        Pflag = 1;
        break;
      case 'p':
        maxbw = atoi(optarg);
        pflag = 1;
        if(maxbw < 1)
          Usage();
        break;
      case 'V':
        rtn = rcsid;
        goto ErrorExit;
      default:
        Usage();
        break;
    }
  }
  if(pflag) {
    throttlesize = 3;
    newthisminute = maxbw;
  }
#ifndef WIN32
  /* line buffer the output */
  if(oflag)
    setlinebuf(stdout);
#endif
#ifdef USEZFLAG
  if(zflag == 0) {
    if(testflag)
      printf(err15);
    else {
      rtn = bigstring2;
      goto ErrorExit;
    }
  }
#endif
  if(rflag) {
    for(c = 0; c < 5; c++)
      past[c] = maxbw * 60;
    newthisminute = 0;
    totalbw = maxbw * 300;
  }
  /* sanity checks */
#ifdef WIN32
  if(sha == NULL) {
    rtn = err5;
    goto ErrorExit;
  }
  if(!*ipaddr) {
    rtn = err4;
    goto ErrorExit;
  }
  if(strchr(ipaddr,'/')==NULL) {
    rtn = err6;
    goto ErrorExit;
  }
  if(dev == NULL)
    interf = 0;
  else
    interf = atoi(dev);
  if((po = pcap_lookupdev(ebuf))==NULL) {
    rtn = err9;
    goto ErrorExit;
  }
  if(interf == 0) {
    fprintf(stderr, err16);
    PrintDeviceList(po);
    CleanExit(0);
  }
  dev = devicename;
  GetAdapterFromList(dev, interf);
  if(dev==NULL) {
    fprintf(stderr, err17);
    PrintDeviceList(po);
    CleanExit(0);
  }
  if(!*(dev + 1)) {
    pi = dev+1;
    po=pi;
    while(*++pi)
      *po++ = *pi++;
    *po=0;
  }
#else
  if((pnet == NULL) && (pmask != NULL)) {
    rtn = err10;
    goto ErrorExit;
  }
  if((pnet != NULL) && (pmask == NULL)) {
    rtn = err11;
    goto ErrorExit;
  }
  if((pnet != NULL) && (pmask != NULL)) {
    usernet = 1;
    if(testflag) {
      printf(err18, pmask, pnet);
    }
  }
#endif
  /* create our bpf filter */
  if(!xflag) {
    strcpy(texpr, bpf);
    if(testflag)
      printf(lbwill, diag1);
  } else {
    if(testflag)
      printf(lbwill, diag2);
  }
  /* tack any additional stuff onto our BPF filter */
  if(optind < argc) {
    if(ffname != NULL) {
      rtn = err12;
      goto ErrorExit;
    }
    if(!xflag)
      strcat(texpr, str22);
    p = texpr;
    while(*p != '\0')
      p++;
    for(c = optind; c < argc; c++) {
      strcpy(p, argv[c]);
      while(*p != '\0')
        p++;
      *p++ = ' ';
      *p = '\0';
    }
    if(!xflag)
      strcat(texpr, str23);
  }
  for(c = 0; c < RANDSIZE2; c++)
    *(randqueue2 + c) = libnet_get_prand(PRu32);
  /* handle filter file */
  if(ffname != NULL) {
    if((in = fopen(ffname, rstring)) == NULL) {
      rtn = err14;
      goto ErrorExit;
    } else {
      if(!xflag)
        strcat(texpr, str22);
      while(boolContinue) {
        rtn = fgets(mybuffer, 1024, in);
        if(rtn != NULL) {
          if(*mybuffer != '#') {
            cleanup2(mybuffer);
            strcat(texpr, mybuffer);
          }
        } else
          boolContinue = 0;
      }
      fclose(in);
      if(!xflag)
        strcat(texpr, str23);
    }
  }
  if(testflag) {
    if(qflag)
      printf(lbwill, diag3);
    if((datalog > 0) && (oflag == 0))
      printf(lbwill, diag4);
    if((datalog > 0) && (oflag == 1))
      printf(lbwill, diag5);
    if(datalog > 1)
      printf(lbwill, diag6);
    if(hflag)
      printf(lbwill, diag7);
    if(sflag)
      printf(lbwill, diag8);
    if(aflag)
      printf(lbwill, diag9);
    if(pflag)
      printf(diag10, maxbw);
    if(hflag)
      printf(lbwill, diag14);
  }
  if(Pflag) {
    if(!pflag)
      Pflag = 0;
    else {
      if(testflag)
        printf(diag11);
    }
  }
#ifdef WIN32
  po = strchr(ipaddr,'/');
  *po++ = 0;
  net = inet_addr(ipaddr);
  mask = getnetmask(po);
  myip = htonl(net);
  net&=mask;
#else
  if((!dflag) && (!testflag))
    GoDaemon();
  /* set up our device */
  if(dev == NULL) {
    if((dev = pcap_lookupdev(ebuf)) == NULL) {
      fprintf(stderr, err19, ebuf);
      exit(1);
    }
  }
  if(testflag)
    printf(diag12, dev);
  if(usernet) {
    net = libnet_name_resolve(pnet,0);
    mask = libnet_name_resolve(pmask,0);
  } else {
    /* get info on our device */
    if(pcap_lookupnet(dev, &net, &mask, ebuf) < 0) {
      fprintf(stderr, err20, dev, ebuf);
      exit(1);
    }
  }
#endif
  /* how many possible addresses in our netblock? */
  addresses = ntohl(mask ^ 0xFFFFFFFF);
  if(xflag)
    addresses = 0;
  /* set our base address */
  base = ntohl(net);
  topend = base + addresses;
  /* allocate our exclusion array */
  exclusion = malloc(addresses+2);
  if(exclusion == NULL) {
    rtn = err8;
    goto ErrorExit;
  }
  /* if we're going to use it, allocate our array for holding ARP times */
  if(!xflag) {
    /* allocate a chunk o' RAM */
    time_array = malloc(sizeof(time_t) * (addresses+2));
    if(time_array == NULL) {
      rtn = err7;
      goto ErrorExit;
    }
    /* allocate a second chunk o' RAM */
    addr_array = malloc(sizeof(time_t) * (addresses+2));
    if(addr_array == NULL) {
      rtn = err13;
      goto ErrorExit;
    }
  }
  /* set up logging */
  /* setup the facility for logging in the makefile djs */
  openlog(argv[0], 0, LOGFAC);
  logopen = 1;
  /* tell 'em we're here... */
  strcpy(mybuffer, diag13);
  strncat(mybuffer, dev, 10);
  if(oflag)
    printf(format5, mybuffer);
  else
    syslog(INFOTYPE, mybuffer);
  FixArrays(0);
  /* check out our link interface (so we can determine link layer data size) */
  if((plnk = libnet_open_link_interface(dev, ebuf)) == NULL) {
    rtn = err21;
    goto ErrorExit;
  } else {
    dlsize = plnk->linkoffset;
  }
  if((dlsize != 14) && !xflag) {
    rtn = bigstring;
    goto ErrorExit;
  }
  /* open our pcap device */
  /* in order for ping to work when the remote machine uses  */
  /* large chunks of data to ping, we need to grab the whole */
  /* packet... this won't work if it's a big enough packet   */
  /* to be fragmented...                                     */
  if((pc = pcap_open_live(dev, 1514, 1, 100, ebuf)) == NULL) {
    rtn = err3;
    goto ErrorExit;
  }
  /* set up our datalink */
  dlink = pcap_datalink(pc);
  /* compile our BPF filter */
  if(pcap_compile(pc, &bpfp, texpr, 1, mask) < 0) {
    rtn = err2;
    goto ErrorExit;
  }
  /* attach our filter to our datalink */
  if(pcap_setfilter(pc, &bpfp) < 0) {
    rtn = err1;
    goto ErrorExit;
  }
  /* get our MAC address to use when we create our arp packets */
  /* Windows version does not have this. We supply MAC addr as argument */
#ifndef WIN32
  if((sha = (u_char *)libnet_get_hwaddr(plnk, dev, ebuf)) == 0) {
    rtn = err22;
    goto ErrorExit;
  }
  if(usernet)
    myip = 0;
  else {
    /* we need our IP address for the same reason... */
    if((myip = libnet_get_ipaddr(plnk, dev, ebuf)) == 0) {
      rtn = err23;
      goto ErrorExit;
    }
    myip = htonl(myip);
  }
#endif
  if(testflag) {
    printf(test1,
           (net & 0xFF),((net & 0xFF00) >> 8),((net & 0xFF0000) >> 16),((net & 0xFF000000) >> 24),
           (mask & 0xFF),((mask & 0xFF00) >> 8),((mask & 0xFF0000) >> 16),((mask & 0xFF000000) >> 24),
           addresses,((base & 0xFF000000) >> 24),((base & 0xFF0000) >> 16),((base & 0xFF00) >> 8),
           (base & 0xFF),((topend & 0xFF000000) >> 24),((topend & 0xFF0000) >> 16),
           ((topend & 0xFF00) >> 8),(topend & 0xFF),
           texpr, throttlesize, rate);
    CleanExit(0);
  }
#ifndef WIN32
  /* fire off an alarm if we're doing persist state capture */
  if(pflag)
    alarm(60);
#else
  if(pflag)
    CloseHandle(CreateThread(NULL,0,ServiceTimer,0,0,&dummy));
#endif
  /* loop! */
  for(;;) {
    if(pcap_loop(pc, 1, &PacketHandler, NULL) < 0) {
      if(oflag) {
        rtn = err24;
        goto ErrorExit;
      } else
        syslog(LOGTYPE, err24);
      CleanExit(0);
    }
  }
  return(0);
  ErrorExit:
  fprintf(stderr, err25, rtn);
  CleanExit(0);
  return(0);
}
