#!/usr/bin/perl

package eBay::API::XML::DataType::StoreCustomPageType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. StoreCustomPageType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::StoreCustomPageType

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::StoreCustomPageType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::Enum::StoreCustomPageStatusCodeType;


my @gaProperties = ( [ 'Content', 'xs:string', '', '', '' ]
	, [ 'LeftNav', 'xs:boolean', '', '', '' ]
	, [ 'Name', 'xs:string', '', '', '' ]
	, [ 'Order', 'xs:int', '', '', '' ]
	, [ 'PageID', 'xs:long', '', '', '' ]
	, [ 'PreviewEnabled', 'xs:boolean', '', '', '' ]
	, [ 'Status', 'ns:StoreCustomPageStatusCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::StoreCustomPageStatusCodeType', '' ]
	, [ 'URL', 'xs:anyURI', '', '', '' ]
	, [ 'URLPath', 'xs:string', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setContent()

The HTML content of the custom page. This field has a maximum size
of 96 kilobytes. If PreviewEnabled is true, then this value is required. 
Otherwise, it is optional.

  Calls: SetStoreCustomPage
  RequiredInput: Conditionally

#    Argument: 'xs:string'

=cut

sub setContent {
  my $self = shift;
  $self->{'Content'} = shift
}

=head2 getContent()

  Calls: GetStoreCustomPage
  Returned: Conditionally

  Calls: SetStoreCustomPage
  Returned: Conditionally

#    Returns: 'xs:string'

=cut

sub getContent {
  my $self = shift;
  return $self->{'Content'};
}


=head2 setLeftNav()

Specifies whether the left navigation bar is visible on the page. LeftNav 
is included in the GetStoreCustomPage response when PageID is specified 
in the request.

  Calls: SetStoreCustomPage
  RequiredInput: Conditionally

#    Argument: 'xs:boolean'

=cut

sub setLeftNav {
  my $self = shift;
  $self->{'LeftNav'} = shift
}

=head2 isLeftNav()

  Calls: GetStoreCustomPage
  Returned: Conditionally

  Calls: SetStoreCustomPage
  Returned: Conditionally

#    Returns: 'xs:boolean'

=cut

sub isLeftNav {
  my $self = shift;
  return $self->{'LeftNav'};
}


=head2 setName()

Name of the Store custom page. This value is required if you are creating a 
new page (by not specifying a PageID). Note that you must include a Name for 
the page even if you are using the PreviewEnabled tag. However, since using 
the preview functionality means that the page will not be persisted, you can 
enter a dummy value for this field if you have not decided on a name for the 
page. The Name is used in links to the page.

  Calls: SetStoreCustomPage
  RequiredInput: Conditionally

#    Argument: 'xs:string'

=cut

sub setName {
  my $self = shift;
  $self->{'Name'} = shift
}

=head2 getName()

  Calls: GetStoreCustomPage
  Returned: Always

  Calls: SetStoreCustomPage
  Returned: Conditionally

#    Returns: 'xs:string'

=cut

sub getName {
  my $self = shift;
  return $self->{'Name'};
}


=head2 setOrder()

Order in which the page is displayed in the list of custom pages.

  Calls: SetStoreCustomPage
  RequiredInput: Conditionally

#    Argument: 'xs:int'

=cut

sub setOrder {
  my $self = shift;
  $self->{'Order'} = shift
}

=head2 getOrder()

  Calls: GetStoreCustomPage
  Returned: Always

  Calls: SetStoreCustomPage
  Returned: Conditionally

#    Returns: 'xs:int'

=cut

sub getOrder {
  my $self = shift;
  return $self->{'Order'};
}


=head2 setPageID()

Unique identifier for the Store custom page. When you are using 
SetStoreCustomPage, if you specify a valid PageID, the custom page
is updated. If you do not specify a PageID, the custom page is
added.

  Calls: SetStoreCustomPage
  RequiredInput: Conditionally

#    Argument: 'xs:long'

=cut

sub setPageID {
  my $self = shift;
  $self->{'PageID'} = shift
}

=head2 getPageID()

  Calls: GetStoreCustomPage
  Returned: Always

  Calls: SetStoreCustomPage
  Returned: Conditionally

#    Returns: 'xs:long'

=cut

sub getPageID {
  my $self = shift;
  return $self->{'PageID'};
}


=head2 setPreviewEnabled()

If true, then the other inputs are ignored, and the content of the
page as it will be displayed within the Store is returned. If
false, then the page is either modified or added, and the content
of the page is not returned.

  Calls: SetStoreCustomPage
  RequiredInput: No

#    Argument: 'xs:boolean'

=cut

sub setPreviewEnabled {
  my $self = shift;
  $self->{'PreviewEnabled'} = shift
}

=head2 isPreviewEnabled()

  Calls: SetStoreCustomPage
  Returned: Conditionally

#    Returns: 'xs:boolean'

=cut

sub isPreviewEnabled {
  my $self = shift;
  return $self->{'PreviewEnabled'};
}


=head2 setStatus()

Status of the custom page, active or inactive. Set Status to Delete with SetStoreCustomPage to delete the page.

  Calls: SetStoreCustomPage
  RequiredInput: Conditionally

#    Argument: 'ns:StoreCustomPageStatusCodeType'

=cut

sub setStatus {
  my $self = shift;
  $self->{'Status'} = shift
}

=head2 getStatus()

  Calls: GetStoreCustomPage
  Returned: Always
  OnlyTheseValues: Active, Inactive

  Calls: SetStoreCustomPage
  Returned: Conditionally

#    Returns: 'ns:StoreCustomPageStatusCodeType'

=cut

sub getStatus {
  my $self = shift;
  return $self->{'Status'};
}


=head2 setURL()

Full URL of the Store custom page. URLPath is included in the 
GetStoreCustomPage response when PageID is specified in the request.

#    Argument: 'xs:anyURI'

=cut

sub setURL {
  my $self = shift;
  $self->{'URL'} = shift
}

=head2 getURL()

  Calls: GetStoreCustomPage
  Returned: Conditionally

#    Returns: 'xs:anyURI'

=cut

sub getURL {
  my $self = shift;
  return $self->{'URL'};
}


=head2 setURLPath()

The URL path of the custom page. Only if you are using Chinese characters in 
the Name property for the custom page do you need to use this field, such as 
if you are opening a Store on the Taiwan site. The reason for this is that 
the URL path is normally derived from the Store custom page name, but it 
cannot be derived from the name of the custom page if it contains Chinese 
characters because URLs cannot contain Chinese characters.
URLPath is included in the GetStoreCustomPage response when PageID is 
specified.

  Calls: SetStoreCustomPage
  RequiredInput: Conditionally

#    Argument: 'xs:string'

=cut

sub setURLPath {
  my $self = shift;
  $self->{'URLPath'} = shift
}

=head2 getURLPath()

  Calls: GetStoreCustomPage
  Returned: Conditionally

  Calls: SetStoreCustomPage
  Returned: Conditionally

#    Returns: 'xs:string'

=cut

sub getURLPath {
  my $self = shift;
  return $self->{'URLPath'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
